/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.IServiceContainer;
import anon.client.AbstractControlChannel;
import anon.client.Multiplexer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logging.LogHolder;
import logging.LogType;

public abstract class StreamedControlChannel
extends AbstractControlChannel {
    private byte[] m_messageBuffer = new byte[0];
    private int m_currentIndex = -2;
    private byte[] m_lengthBuffer = new byte[2];
    private boolean m_bIsEncrypted;

    public StreamedControlChannel(int a_channelId, Multiplexer a_multiplexer, IServiceContainer a_serviceContainer, boolean bEncrypted) {
        super(a_channelId, a_multiplexer, a_serviceContainer);
        this.m_bIsEncrypted = bEncrypted;
    }

    public int sendByteMessage(byte[] a_message) {
        if (a_message.length > 65535) {
            return -31;
        }
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        DataOutputStream dataOutputBuffer = new DataOutputStream(outputBuffer);
        try {
            dataOutputBuffer.writeShort(a_message.length);
            dataOutputBuffer.flush();
            byte[] buff = null;
            if (this.m_bIsEncrypted && this.m_parentMultiplexer.getControlChannelCipher() != null) {
                buff = new byte[this.m_parentMultiplexer.getControlChannelCipher().getEncryptedOutputSize(a_message.length)];
                this.m_parentMultiplexer.getControlChannelCipher().encryptGCM1(a_message, 0, buff, 0, a_message.length);
            } else {
                buff = a_message;
            }
            outputBuffer.write(buff);
            outputBuffer.flush();
        }
        catch (Exception e) {
            LogHolder.log(1, LogType.NET, e);
        }
        return this.sendRawMessage(outputBuffer.toByteArray());
    }

    protected void processPacketData(byte[] a_packetData) {
        int currentPacketIndex = 0;
        while (currentPacketIndex < a_packetData.length) {
            if (this.m_currentIndex < 0) {
                int lengthBytesToRead = Math.min(-this.m_currentIndex, a_packetData.length - currentPacketIndex);
                System.arraycopy(a_packetData, currentPacketIndex, this.m_lengthBuffer, this.m_lengthBuffer.length + this.m_currentIndex, lengthBytesToRead);
                this.m_currentIndex += lengthBytesToRead;
                currentPacketIndex += lengthBytesToRead;
                if (this.m_currentIndex == 0) {
                    try {
                        int len = new DataInputStream(new ByteArrayInputStream(this.m_lengthBuffer)).readUnsignedShort();
                        if (this.m_bIsEncrypted && this.m_parentMultiplexer.getControlChannelCipher() != null) {
                            len = this.m_parentMultiplexer.getControlChannelCipher().getEncryptedOutputSize(len);
                        }
                        this.m_messageBuffer = new byte[len];
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            if (this.m_currentIndex >= 0 && this.m_currentIndex < this.m_messageBuffer.length) {
                int messageBytesToRead = Math.min(this.m_messageBuffer.length - this.m_currentIndex, a_packetData.length - currentPacketIndex);
                System.arraycopy(a_packetData, currentPacketIndex, this.m_messageBuffer, this.m_currentIndex, messageBytesToRead);
                this.m_currentIndex += messageBytesToRead;
                currentPacketIndex += messageBytesToRead;
            }
            if (this.m_currentIndex < this.m_messageBuffer.length) continue;
            byte[] buff = null;
            if (this.m_bIsEncrypted && this.m_parentMultiplexer.getControlChannelCipher() != null) {
                buff = new byte[this.m_parentMultiplexer.getControlChannelCipher().getDecryptedOutputSize(this.m_messageBuffer.length)];
                try {
                    this.m_parentMultiplexer.getControlChannelCipher().decryptGCM2(this.m_messageBuffer, 0, buff, 0, this.m_messageBuffer.length);
                }
                catch (Exception e) {
                    buff = null;
                }
            } else {
                buff = this.m_messageBuffer;
            }
            this.processMessage(buff);
            this.m_messageBuffer = new byte[0];
            this.m_currentIndex = -2;
        }
    }

    protected abstract void processMessage(byte[] var1);
}

