/*
 * Decompiled with CFR 0.152.
 */
package logging;

import logging.AbstractLog;
import logging.ILog;

public final class ChainedLog
implements ILog {
    private ILog m_Log1;
    private ILog m_Log2;
    private boolean m_bConstantLevel1;
    private boolean m_bConstantLevel2;
    private boolean m_bConstantType1;
    private boolean m_bConstantType2;

    public ChainedLog(ILog log1, ILog log2) {
        this.m_Log1 = log1;
        this.m_Log2 = log2;
    }

    public synchronized void log(int level, int type, String mesg) {
        this.m_Log1.log(level, type, mesg);
        this.m_Log2.log(level, type, mesg);
    }

    public synchronized void setLogType(int type) {
        if (!this.m_bConstantType1) {
            this.m_Log1.setLogType(type);
        }
        if (!this.m_bConstantType2) {
            this.m_Log2.setLogType(type);
        }
    }

    public synchronized void setConstantLogLevel(ILog a_log, boolean a_bConstant) {
        if (this.m_Log1 == a_log) {
            this.m_bConstantLevel1 = a_bConstant;
        } else if (this.m_Log2 == a_log) {
            this.m_bConstantLevel2 = a_bConstant;
        }
    }

    public synchronized void setConstantLogType(ILog a_log, boolean a_bConstant) {
        if (this.m_Log1 == a_log) {
            this.m_bConstantType1 = a_bConstant;
        } else if (this.m_Log2 == a_log) {
            this.m_bConstantType2 = a_bConstant;
        }
    }

    public boolean isLogged(int a_logLevel, int a_logType) {
        return AbstractLog.isLogged(this.m_Log1, a_logLevel, a_logType) || AbstractLog.isLogged(this.m_Log2, a_logLevel, a_logType);
    }

    public int getLogType() {
        if (!this.m_bConstantType1) {
            return this.m_Log1.getLogType();
        }
        return this.m_Log2.getLogType();
    }

    public synchronized void setLogLevel(int level) {
        if (!this.m_bConstantLevel1) {
            this.m_Log1.setLogLevel(level);
        }
        if (!this.m_bConstantLevel2) {
            this.m_Log2.setLogLevel(level);
        }
    }

    public int getLogLevel() {
        if (!this.m_bConstantLevel1) {
            return this.m_Log1.getLogLevel();
        }
        return this.m_Log2.getLogLevel();
    }
}

