/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HttpClientUtil;
import java.io.IOException;
import java.io.OutputStream;

final class ExtByteArrayOutputStream {
    private byte[] buf;
    private int count;

    public ExtByteArrayOutputStream() {
        this(100);
    }

    public ExtByteArrayOutputStream(int size) {
        this.buf = new byte[size];
        this.count = 0;
    }

    public final void write(String str) {
        int len = str.length();
        if (this.buf.length - this.count < len) {
            this.buf = HttpClientUtil.resizeArray(this.buf, Math.max(this.buf.length * 2, this.count + 2 * len));
        }
        HttpClientUtil.getBytes(str, this.buf, this.count);
        this.count += len;
    }

    public final void write(String str1, String str2) {
        int len2;
        int len1 = str1.length();
        if (this.buf.length - this.count < len1 + (len2 = str2.length())) {
            this.buf = HttpClientUtil.resizeArray(this.buf, Math.max(this.buf.length * 2, this.count + 2 * (len1 + len2)));
        }
        HttpClientUtil.getBytes(str1, this.buf, this.count);
        this.count += len1;
        HttpClientUtil.getBytes(str2, this.buf, this.count);
        this.count += len2;
    }

    public final void write(String str1, String str2, String str3) {
        int len3;
        int len2;
        int len1 = str1.length();
        if (this.buf.length - this.count < len1 + (len2 = str2.length()) + (len3 = str3.length())) {
            this.buf = HttpClientUtil.resizeArray(this.buf, Math.max(this.buf.length * 2, this.count + 2 * (len1 + len2 + len3)));
        }
        HttpClientUtil.getBytes(str1, this.buf, this.count);
        this.count += len1;
        HttpClientUtil.getBytes(str2, this.buf, this.count);
        this.count += len2;
        HttpClientUtil.getBytes(str3, this.buf, this.count);
        this.count += len3;
    }

    public final void write(byte[] data) {
        if (this.buf.length - this.count < data.length) {
            this.buf = HttpClientUtil.resizeArray(this.buf, Math.max(this.buf.length * 2, this.count + 2 * data.length));
        }
        System.arraycopy(data, 0, this.buf, this.count, data.length);
        this.count += data.length;
    }

    public final void reset() {
        this.count = 0;
    }

    public final void writeTo(OutputStream os) throws IOException {
        os.write(this.buf, 0, this.count);
    }
}

