/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage.crypto;

import anon.anonudp.mixmessage.Util;

public class Counter {
    public static final int SIZE = 4;
    private int currentValue;

    public Counter() {
        this(0);
    }

    public Counter(int startValue) {
        this.currentValue = startValue;
    }

    public Counter(byte[] prefix) {
        this(Util.bytesToUnsignedInt(prefix));
    }

    public int asInt() {
        return this.currentValue;
    }

    public void count() {
        ++this.currentValue;
    }

    public byte[] asBytes() {
        return Util.unsignedIntToBytes(this.currentValue);
    }

    public byte[] asIV() {
        byte[] iv = new byte[16];
        System.arraycopy(this.asBytes(), 0, iv, 0, 4);
        return iv;
    }

    public void asIV(byte[] iv) {
        iv[0] = (byte)(this.currentValue >> 24 & 0xFF);
        iv[1] = (byte)(this.currentValue >> 16 & 0xFF);
        iv[2] = (byte)(this.currentValue >> 8 & 0xFF);
        iv[3] = (byte)(this.currentValue & 0xFF);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Counter) {
            return this.currentValue == ((Counter)obj).asInt();
        }
        return super.equals(obj);
    }
}

