/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.AnonChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AnonTCPChannel
implements AnonChannel {
    private AnonChannel m_channelUnderlyingChannel = null;

    protected AnonTCPChannel(AnonChannel a_channelUnderlyingChannel) {
        this.m_channelUnderlyingChannel = a_channelUnderlyingChannel;
    }

    public void connect(String hostname, int port) throws IOException {
        OutputStream out = this.getOutputStream();
        int lenHostname = hostname.length();
        byte[] req = new byte[lenHostname + 10];
        req[0] = 5;
        req[1] = 1;
        req[2] = 0;
        req[3] = 5;
        req[4] = 1;
        req[6] = 3;
        req[7] = (byte)lenHostname;
        byte[] bar_hostname = hostname.getBytes();
        System.arraycopy(bar_hostname, 0, req, 8, lenHostname);
        req[8 + lenHostname] = (byte)(port >> 8 & 0xFF);
        req[9 + lenHostname] = (byte)(port & 0xFF);
        out.write(req);
        out.flush();
        InputStream in = this.getInputStream();
        int ret = in.read(req, 0, 2);
        ret = in.read();
        int result = in.read();
        if (result != 0) {
            this.close();
            throw new IOException("Connect to: " + hostname + " not successful!");
        }
        in.read();
        int atype = in.read();
        if (atype == 1) {
            in.read(req, 0, 6);
        } else if (atype == 4) {
            in.read(req, 0, 18);
        } else if (atype == 3) {
            int len = in.read();
            in.read(req, 0, len);
        } else {
            this.close();
            throw new IOException("Connect not successful!");
        }
    }

    public void setSentAutoFlushDelay(int msAutoFlushDelay) {
    }

    public InputStream getInputStream() {
        return this.m_channelUnderlyingChannel.getInputStream();
    }

    public OutputStream getOutputStream() {
        return new AnonTCPChannelOutputStream(this.m_channelUnderlyingChannel.getOutputStream());
    }

    public int getOutputBlockSize() {
        return this.m_channelUnderlyingChannel.getOutputBlockSize();
    }

    public void close() {
        this.m_channelUnderlyingChannel.close();
    }

    public boolean isClosed() {
        return this.m_channelUnderlyingChannel.isClosed();
    }

    class AnonTCPChannelOutputStream
    extends OutputStream {
        OutputStream m_Out;

        AnonTCPChannelOutputStream(OutputStream out) {
            this.m_Out = out;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.m_Out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                int i = Math.min(AnonTCPChannel.this.m_channelUnderlyingChannel.getOutputBlockSize(), len);
                this.m_Out.write(b, off, i);
                off += i;
                len -= i;
            }
        }

        public void flush() throws IOException {
            this.m_Out.flush();
        }

        public void close() throws IOException {
            this.m_Out.close();
        }
    }
}

