/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.crypto.ISymCipher;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class MixPacket {
    private static final int PACKET_SIZE = 998;
    private static final int HEADER_SIZE = 6;
    private static final int PAYLOAD_SIZE = 992;
    public static final short FLAG_CHANNEL_DATA = 0;
    public static final short FLAG_CHANNEL_CLOSE = 1;
    public static final short FLAG_CHANNEL_OPEN = 8;
    public static final short FLAG_CHANNEL_DUMMY = 16;
    public static final short FLAG_DEBUG = 32;
    private static final SecureRandom ms_secureRandom = new SecureRandom();
    private int m_channelId;
    private short m_channelFlags;
    private byte[] m_payloadData;
    private Vector m_sendCallbackHandlers = new Vector();

    public static int getPacketSize() {
        return 998;
    }

    public static int getPayloadSize() {
        return 992;
    }

    public MixPacket(InputStream a_inputStream, ISymCipher a_inputStreamCipher) throws IOException {
        int length;
        byte[] rawPacket = new byte[998];
        int pos = 0;
        try {
            int ret;
            for (length = 998; length > 0; length -= ret) {
                ret = a_inputStream.read(rawPacket, pos, length);
                if (ret < 0) {
                    throw new EOFException();
                }
                pos += ret;
            }
        }
        catch (EOFException eofe) {
            LogHolder.log(4, LogType.NET, Thread.currentThread().getName() + ": received a truncated packet from a mix: ", eofe);
            throw eofe;
        }
        catch (IOException a_e) {
            try {
                Class<?> classSocketTimeoutException = Class.forName("java.net.SocketTimeoutException");
                if (classSocketTimeoutException.isAssignableFrom(a_e.getClass())) {
                    while (length > 0) {
                        int ret = a_inputStream.read(rawPacket, pos, length);
                        if (ret < 0) {
                            throw new EOFException();
                        }
                        pos += ret;
                        length -= ret;
                    }
                }
                throw a_e;
            }
            catch (ClassNotFoundException e) {
                throw a_e;
            }
        }
        if (a_inputStreamCipher != null) {
            a_inputStreamCipher.encryptAES1(rawPacket, 0, rawPacket, 0, 16);
        }
        this.m_channelId = (rawPacket[0] & 0xFF) << 24 | (rawPacket[1] & 0xFF) << 16 | (rawPacket[2] & 0xFF) << 8 | rawPacket[3] & 0xFF;
        this.m_channelFlags = (short)((rawPacket[4] & 0xFF) << 8 | rawPacket[5] & 0xFF);
        this.m_payloadData = new byte[992];
        System.arraycopy(rawPacket, 6, this.m_payloadData, 0, 992);
    }

    public MixPacket(int a_channelId) {
        this.m_channelId = a_channelId;
        this.m_channelFlags = 0;
        this.m_payloadData = new byte[992];
        ms_secureRandom.nextBytes(this.m_payloadData);
    }

    public int getChannelId() {
        return this.m_channelId;
    }

    public short getChannelFlags() {
        return this.m_channelFlags;
    }

    public void setChannelFlags(short a_channelFlags) {
        this.m_channelFlags = a_channelFlags;
    }

    public byte[] getPayloadData() {
        return this.m_payloadData;
    }

    public byte[] getRawPacket() {
        byte[] rawPacket = new byte[998];
        rawPacket[0] = (byte)(this.m_channelId >> 24 & 0xFF);
        rawPacket[1] = (byte)(this.m_channelId >> 16 & 0xFF);
        rawPacket[2] = (byte)(this.m_channelId >> 8 & 0xFF);
        rawPacket[3] = (byte)(this.m_channelId & 0xFF);
        rawPacket[4] = (byte)(this.m_channelFlags >> 8 & 0xFF);
        rawPacket[5] = (byte)(this.m_channelFlags & 0xFF);
        System.arraycopy(this.m_payloadData, 0, rawPacket, 6, 992);
        return rawPacket;
    }

    public Vector getSendCallbackHandlers() {
        return this.m_sendCallbackHandlers;
    }
}

