/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.CertPath;
import anon.crypto.JAPCertificate;

public class CertificateInfoStructure {
    private CertPath m_certPath;
    private JAPCertificate m_parentCertificate;
    private int m_certificateType;
    private boolean m_enabled;
    private boolean m_certificateNeedsVerification;
    private boolean m_onlyHardRemovable;
    private boolean m_bNotRemovable;

    public CertificateInfoStructure(CertPath a_certPath, JAPCertificate a_parentCertificate, int a_certificateType, boolean a_enabled, boolean a_certificateNeedsVerification, boolean a_onlyHardRemovable, boolean a_notRemovable) {
        if (a_certPath == null) {
            throw new IllegalArgumentException("CertPath may not be null");
        }
        this.m_certPath = a_certPath;
        this.m_parentCertificate = a_parentCertificate;
        this.m_certificateType = a_certificateType;
        this.m_enabled = a_enabled;
        this.m_certificateNeedsVerification = a_certificateNeedsVerification;
        this.m_onlyHardRemovable = a_onlyHardRemovable;
        this.m_bNotRemovable = a_notRemovable;
    }

    public JAPCertificate getCertificate() {
        return this.m_certPath.getFirstCertificate();
    }

    public JAPCertificate getParentCertificate() {
        return this.m_parentCertificate;
    }

    public CertPath getCertPath() {
        return this.m_certPath;
    }

    public int getCertificateType() {
        return this.m_certificateType;
    }

    public boolean getCertificateNeedsVerification() {
        return this.m_certificateNeedsVerification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        boolean returnValue = false;
        CertificateInfoStructure certificateInfoStructure = this;
        synchronized (certificateInfoStructure) {
            returnValue = (!this.m_certificateNeedsVerification || this.m_parentCertificate != null) && this.m_enabled;
        }
        return returnValue;
    }

    public boolean isOnlyHardRemovable() {
        return this.m_onlyHardRemovable;
    }

    public boolean isNotRemovable() {
        return this.m_bNotRemovable;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }
}

