/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.server;

import anon.forward.ForwardUtils;
import anon.forward.server.ForwardConnection;
import anon.forward.server.ForwardServerManager;
import anon.forward.server.IProtocolHandler;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultProtocolHandler
implements IProtocolHandler {
    private static final int PROTOCOL_VERSION = 2;
    private static final int MAXIMUM_PROTOCOLMESSAGE_SIZE = 100000;
    private static final byte[] MESSAGE_START_SIGNATURE = new byte[]{-1, 0, -16, 15};
    private static final byte[] MESSAGE_START_COMPRESS_SIGNATURE = new byte[]{-1, 15, -16, 15};
    private static final byte[] MESSAGE_END_SIGNATURE = new byte[]{-1, 0, -31, 30};
    private static final int STATE_WAIT_FOR_CLIENT_REQUEST = 0;
    private static final int STATE_WAIT_FOR_CASCADE_SELECTION = 1;
    private static final int STATE_CONNECTED_TO_MIX = 2;
    private static final int STATE_CONNECTION_CLOSED = 3;
    private static final int STATE_WAIT_FOR_INFOSERVICE_CLOSE = 4;
    private Socket m_serverConnection;
    private ByteArrayOutputStream m_incomingMessageBuffer = new ByteArrayOutputStream();
    private int m_incomingMessageLength = -1;
    private ByteArrayInputStream m_outgoingMessageBuffer = new ByteArrayInputStream(new byte[0]);
    private int m_currentState;
    private ForwardConnection m_parentConnection;
    private boolean m_doCompress;

    public DefaultProtocolHandler(ForwardConnection a_parentConnection) throws Exception {
        this.m_parentConnection = a_parentConnection;
        this.m_serverConnection = null;
        this.m_currentState = 0;
        this.m_doCompress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws Exception {
        int availableData = 0;
        if (this.m_serverConnection != null) {
            availableData = this.m_serverConnection.getInputStream().available();
        } else {
            ByteArrayInputStream byteArrayInputStream = this.m_outgoingMessageBuffer;
            synchronized (byteArrayInputStream) {
                availableData = this.m_outgoingMessageBuffer.available();
            }
        }
        return availableData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] a_buffer) throws Exception {
        int bytesRead = 0;
        if (this.m_serverConnection != null) {
            bytesRead = this.m_serverConnection.getInputStream().read(a_buffer);
            if (bytesRead != 0) {
                LogHolder.log(7, LogType.TRANSPORT, "We read " + bytesRead + " bytes from the server (read from handler)");
            }
        } else {
            ByteArrayInputStream byteArrayInputStream = this.m_outgoingMessageBuffer;
            synchronized (byteArrayInputStream) {
                bytesRead = this.m_outgoingMessageBuffer.read(a_buffer);
            }
            if (bytesRead == -1) {
                bytesRead = 0;
            } else {
                LogHolder.log(7, LogType.TRANSPORT, "We read " + bytesRead + " bytes from the server (read from handler, message protocol)");
            }
        }
        return bytesRead;
    }

    public void write(byte[] a_buffer) throws Exception {
        if (this.m_serverConnection != null) {
            this.m_serverConnection.getOutputStream().write(a_buffer);
            this.m_serverConnection.getOutputStream().flush();
        } else {
            this.messageHandler(a_buffer);
        }
    }

    public void close() {
        if (this.m_serverConnection != null) {
            try {
                this.m_serverConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_serverConnection = null;
        }
        this.m_incomingMessageBuffer = null;
        this.m_outgoingMessageBuffer = null;
        this.m_currentState = 3;
    }

    private boolean checkSignature(byte[] a_signature1, byte[] a_signature2) {
        boolean identical = false;
        try {
            if (a_signature1.length == a_signature2.length) {
                identical = true;
                for (int i = 0; i < a_signature1.length && identical; ++i) {
                    if (a_signature1[i] == a_signature2[i]) continue;
                    identical = false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return identical;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void messageHandler(byte[] a_newData) throws Exception {
        boolean isCompress = false;
        if (this.m_incomingMessageBuffer.size() < MESSAGE_START_SIGNATURE.length + 4) {
            if (this.m_incomingMessageBuffer.size() < MESSAGE_START_SIGNATURE.length) {
                this.m_incomingMessageBuffer.write(a_newData);
                if (this.m_incomingMessageBuffer.size() >= MESSAGE_START_SIGNATURE.length) {
                    byte[] messageStart = new byte[MESSAGE_START_SIGNATURE.length];
                    System.arraycopy(this.m_incomingMessageBuffer.toByteArray(), 0, messageStart, 0, MESSAGE_START_SIGNATURE.length);
                    if (!this.checkSignature(messageStart, MESSAGE_START_SIGNATURE)) {
                        if (!this.checkSignature(messageStart, MESSAGE_START_COMPRESS_SIGNATURE)) throw new Exception("DefaultProtocolHandler: messageHandler: Protocol error (invalid start signature).");
                        isCompress = true;
                    }
                }
            } else {
                this.m_incomingMessageBuffer.write(a_newData);
            }
            if (this.m_incomingMessageBuffer.size() >= MESSAGE_START_SIGNATURE.length + 4) {
                byte[] netLength = new byte[4];
                System.arraycopy(this.m_incomingMessageBuffer.toByteArray(), MESSAGE_START_SIGNATURE.length, netLength, 0, 4);
                try {
                    this.m_incomingMessageLength = new DataInputStream(new ByteArrayInputStream(netLength)).readInt();
                }
                catch (Exception e) {
                    throw new Exception("DefaultProtocolHandler: messageHandler: Error while reading message length.");
                }
                if (this.m_incomingMessageLength < 0 || this.m_incomingMessageLength > 100000) {
                    this.m_incomingMessageLength = -1;
                    throw new Exception("DefaultProtocolHandler: messageHandler: Protocol error (invalid length).");
                }
            }
        } else {
            this.m_incomingMessageBuffer.write(a_newData);
        }
        if (this.m_incomingMessageLength == -1 || this.m_incomingMessageBuffer.size() < MESSAGE_START_SIGNATURE.length + 4 + this.m_incomingMessageLength + MESSAGE_END_SIGNATURE.length) return;
        byte[] messageEnd = new byte[MESSAGE_END_SIGNATURE.length];
        System.arraycopy(this.m_incomingMessageBuffer.toByteArray(), MESSAGE_START_SIGNATURE.length + 4 + this.m_incomingMessageLength, messageEnd, 0, MESSAGE_END_SIGNATURE.length);
        if (!this.checkSignature(messageEnd, MESSAGE_END_SIGNATURE)) {
            throw new Exception("DefaultProtocolHandler: messageHandler: Protocol error (invalid end signature).");
        }
        byte[] brutMessage = new byte[this.m_incomingMessageLength];
        System.arraycopy(this.m_incomingMessageBuffer.toByteArray(), MESSAGE_START_SIGNATURE.length + 4, brutMessage, 0, this.m_incomingMessageLength);
        byte[] currentMessage = isCompress ? ZLibTools.decompress(brutMessage) : brutMessage;
        byte[] otherMessages = new byte[this.m_incomingMessageBuffer.size() - MESSAGE_START_SIGNATURE.length - 4 - this.m_incomingMessageLength - MESSAGE_END_SIGNATURE.length];
        System.arraycopy(this.m_incomingMessageBuffer.toByteArray(), MESSAGE_START_SIGNATURE.length + 4 + this.m_incomingMessageLength + MESSAGE_END_SIGNATURE.length, otherMessages, 0, otherMessages.length);
        this.m_incomingMessageBuffer.reset();
        this.m_incomingMessageLength = -1;
        this.m_incomingMessageBuffer.write(otherMessages);
        this.messageReceived(currentMessage);
        if (this.m_incomingMessageBuffer.size() <= 0) return;
        this.m_incomingMessageBuffer.reset();
        this.messageHandler(otherMessages);
    }

    private void messageReceived(byte[] a_newMessage) throws Exception {
        LogHolder.log(7, LogType.FORWARDING, "We received a Forwarding XML Control message from a client");
        Document doc = XMLUtil.toXMLDocument(a_newMessage);
        NodeList japRoutingNodes = doc.getElementsByTagName("JAPRouting");
        if (japRoutingNodes.getLength() == 0) {
            throw new Exception("DefaultProtocolHandler: messageReceived: Error in XML structure (JAPRouting node).");
        }
        Element japRoutingNode = (Element)japRoutingNodes.item(0);
        this.handleProtocol(japRoutingNode);
    }

    private void handleProtocol(Element a_japRoutingNode) throws Exception {
        switch (this.m_currentState) {
            case 0: {
                this.handleInitialRequestMessage(a_japRoutingNode);
                break;
            }
            case 1: {
                this.handleClientCascadeSelectMessage(a_japRoutingNode);
                break;
            }
            default: {
                throw new Exception("DefaultProtocolHandler: handleProtocol: Protocol error.");
            }
        }
    }

    private void handleInitialRequestMessage(Element a_japRoutingNode) throws Exception {
        NodeList requestNodes = a_japRoutingNode.getElementsByTagName("Request");
        if (requestNodes.getLength() == 0) {
            throw new Exception("DefaultProtocolHandler: handleInitialRequestMessage: Error in XML structure (Request node).");
        }
        Element requestNode = (Element)requestNodes.item(0);
        String subject = requestNode.getAttribute("subject");
        if (!subject.equals("connection")) {
            throw new Exception("DefaultProtocolHandler: handleInitialRequestMessage: Error in XML structure (Request node, wrong subject).");
        }
        String msg = requestNode.getAttribute("msg");
        if (msg.equals("request")) {
            String compress = requestNode.getAttribute("compress");
            if (compress.equals("zip")) {
                LogHolder.log(7, LogType.FORWARDING, "Start compress protocol");
                this.m_doCompress = true;
            }
            this.m_currentState = 1;
            this.sendProtocolDataToClient(this.xmlToProtocolPacket(this.generateConnectionOfferXml()));
        } else if (msg.equals("verify")) {
            this.m_currentState = 4;
            this.sendProtocolDataToClient(this.xmlToProtocolPacket(this.generateConnectionAcknowledgement()));
        } else {
            throw new Exception("DefaultProtocolHandler: handleInitialRequestMessage: Error in XML structure (Request node, wrong msg).");
        }
    }

    private void handleClientCascadeSelectMessage(Element a_japRoutingNode) throws Exception {
        NodeList requestNodes = a_japRoutingNode.getElementsByTagName("Request");
        LogHolder.log(7, LogType.TRANSPORT, "We receveid a CascadeSelectMessage : try to start cascade connection");
        if (requestNodes.getLength() == 0) {
            throw new Exception("DefaultProtocolHandler: handleClientCascadeSelectMessage: Error in XML structure (Request node).");
        }
        Element requestNode = (Element)requestNodes.item(0);
        String subject = requestNode.getAttribute("subject");
        if (!subject.equals("cascade")) {
            throw new Exception("DefaultProtocolHandler: handleClientCascadeSelectMessage: Error in XML structure (Request node, wrong subject).");
        }
        String msg = requestNode.getAttribute("msg");
        if (!msg.equals("select")) {
            throw new Exception("DefaultProtocolHandler: handleClientCascadeSelectMessage: Error in XML structure (Request node, wrong msg).");
        }
        NodeList mixCascadeNodes = requestNode.getElementsByTagName("MixCascade");
        if (mixCascadeNodes.getLength() == 0) {
            throw new Exception("DefaultProtocolHandler: handleClientCascadeSelectMessage: Error in XML structure (MixCascade node).");
        }
        Element mixCascadeNode = (Element)mixCascadeNodes.item(0);
        String selectedCascadeId = mixCascadeNode.getAttribute("id");
        MixCascade selectedCascade = ForwardServerManager.getInstance().getAllowedCascadesDatabase().getMixCascadeById(selectedCascadeId);
        if (selectedCascade == null) {
            throw new Exception("DefaultProtocolHandler: handleClientCascadeSelectMessage: Selected cascade not available.");
        }
        if (!this.connectTo(selectedCascade)) {
            this.close();
            throw new Exception("DefaultProtocolHandler: handleClientCascadeSelectMessage: Error connecting the selected cascade.");
        }
        this.emptyBuffers();
        this.m_currentState = 2;
    }

    private boolean connectTo(MixCascade a_selectedCascade) {
        for (int i = 0; i < a_selectedCascade.getNumberOfListenerInterfaces() && this.m_serverConnection == null; ++i) {
            ListenerInterface currentListenerInterface = a_selectedCascade.getListenerInterface(i);
            try {
                this.m_serverConnection = ForwardUtils.getInstance().createConnection(currentListenerInterface.getHost(), currentListenerInterface.getPort());
                this.m_serverConnection.setSoTimeout(0);
                continue;
            }
            catch (Exception e) {
                this.m_serverConnection = null;
            }
        }
        return this.m_serverConnection != null;
    }

    private void emptyBuffers() throws Exception {
        this.m_serverConnection.getOutputStream().write(this.m_incomingMessageBuffer.toByteArray());
    }

    private Document generateConnectionOfferXml() throws Exception {
        Document doc = XMLUtil.createDocument();
        Element japRoutingNode = doc.createElement("JAPRouting");
        Element protocolNode = doc.createElement("Protocol");
        protocolNode.setAttribute("version", Integer.toString(2));
        japRoutingNode.appendChild(protocolNode);
        Element requestNode = doc.createElement("Request");
        requestNode.setAttribute("subject", "connection");
        requestNode.setAttribute("msg", "offer");
        requestNode.appendChild(ForwardServerManager.getInstance().getAllowedCascadesDatabase().toXmlNode(doc));
        Element qualityOfServiceNode = doc.createElement("QualityOfService");
        Element maximumBandwidthNode = doc.createElement("MaximumBandwidth");
        maximumBandwidthNode.appendChild(doc.createTextNode(Integer.toString(this.m_parentConnection.getParentScheduler().getMaximumBandwidth())));
        qualityOfServiceNode.appendChild(maximumBandwidthNode);
        Element guaranteedBandwidthNode = doc.createElement("GuaranteedBandwidth");
        guaranteedBandwidthNode.appendChild(doc.createTextNode(Integer.toString(this.m_parentConnection.getParentScheduler().getGuaranteedBandwidth())));
        qualityOfServiceNode.appendChild(guaranteedBandwidthNode);
        requestNode.appendChild(qualityOfServiceNode);
        Element dummyTrafficNode = doc.createElement("DummyTraffic");
        dummyTrafficNode.setAttribute("interval", Integer.toString(ForwardServerManager.getInstance().getDummyTrafficInterval()));
        requestNode.appendChild(dummyTrafficNode);
        japRoutingNode.appendChild(requestNode);
        doc.appendChild(japRoutingNode);
        return doc;
    }

    private Document generateConnectionAcknowledgement() throws Exception {
        Document doc = XMLUtil.createDocument();
        Element japRoutingNode = doc.createElement("JAPRouting");
        Element requestNode = doc.createElement("Request");
        requestNode.setAttribute("subject", "connection");
        requestNode.setAttribute("msg", "acknowledge");
        japRoutingNode.appendChild(requestNode);
        doc.appendChild(japRoutingNode);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendProtocolDataToClient(byte[] a_data) {
        ByteArrayInputStream byteArrayInputStream = this.m_outgoingMessageBuffer;
        synchronized (byteArrayInputStream) {
            byte[] tempBuffer = new byte[this.m_outgoingMessageBuffer.available() + a_data.length];
            this.m_outgoingMessageBuffer.read(tempBuffer, 0, this.m_outgoingMessageBuffer.available());
            System.arraycopy(a_data, 0, tempBuffer, tempBuffer.length - a_data.length, a_data.length);
            this.m_outgoingMessageBuffer = new ByteArrayInputStream(tempBuffer);
        }
    }

    private byte[] xmlToProtocolPacket(Document a_doc) throws Exception {
        return this.createProtocolPacket(XMLUtil.toByteArray(a_doc));
    }

    private byte[] createProtocolPacket(byte[] a_data) {
        byte[] protocolPacket;
        int length;
        byte[] compressedData = null;
        if (this.m_doCompress) {
            compressedData = ZLibTools.compress(a_data);
            length = compressedData.length;
            protocolPacket = new byte[MESSAGE_START_SIGNATURE.length + 4 + length + MESSAGE_END_SIGNATURE.length];
            System.arraycopy(MESSAGE_START_COMPRESS_SIGNATURE, 0, protocolPacket, 0, MESSAGE_START_SIGNATURE.length);
        } else {
            length = a_data.length;
            protocolPacket = new byte[MESSAGE_START_SIGNATURE.length + 4 + length + MESSAGE_END_SIGNATURE.length];
            System.arraycopy(MESSAGE_START_SIGNATURE, 0, protocolPacket, 0, MESSAGE_START_SIGNATURE.length);
        }
        ByteArrayOutputStream dataLength = new ByteArrayOutputStream(4);
        try {
            new DataOutputStream(dataLength).writeInt(length);
            System.arraycopy(dataLength.toByteArray(), 0, protocolPacket, MESSAGE_START_SIGNATURE.length, 4);
        }
        catch (Exception e) {
            byte[] dummyLength = new byte[]{-1, -1, -1, -1};
            System.arraycopy(dummyLength, 0, protocolPacket, MESSAGE_START_SIGNATURE.length, 4);
        }
        if (this.m_doCompress) {
            System.arraycopy(compressedData, 0, protocolPacket, MESSAGE_START_SIGNATURE.length + 4, length);
        } else {
            System.arraycopy(a_data, 0, protocolPacket, MESSAGE_START_SIGNATURE.length + 4, length);
        }
        System.arraycopy(MESSAGE_END_SIGNATURE, 0, protocolPacket, MESSAGE_START_SIGNATURE.length + 4 + length, MESSAGE_END_SIGNATURE.length);
        return protocolPacket;
    }
}

