/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.server;

import anon.forward.server.ForwardConnection;
import anon.forward.server.ForwardSchedulerStatistics;
import anon.forward.server.IServerManager;
import anon.transport.address.Endpoint;
import anon.transport.connection.IStreamConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class ForwardScheduler
implements Runnable {
    private static final long CYCLE_TIME = 100L;
    private int m_nrOfConnections = 0;
    private int m_netBandwidth = 0;
    private Vector m_connectionHandler = new Vector();
    private boolean m_shutdown = false;
    private Thread m_schedulerThread;
    private Hashtable m_serverManagers = new Hashtable();
    private ForwardSchedulerStatistics m_statistics;

    public ForwardScheduler() {
        this.m_schedulerThread = new Thread((Runnable)this, "ForwardScheduler");
        this.m_schedulerThread.setDaemon(true);
        this.m_schedulerThread.start();
        this.m_statistics = new ForwardSchedulerStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewConnection(IStreamConnection a_newConnection) {
        boolean connectionAccepted = false;
        ForwardConnection newConnection = null;
        Vector vector = this.m_connectionHandler;
        synchronized (vector) {
            if (this.m_connectionHandler.size() < this.m_nrOfConnections && !this.m_shutdown) {
                try {
                    newConnection = new ForwardConnection(a_newConnection, this);
                    this.m_connectionHandler.addElement(newConnection);
                    connectionAccepted = true;
                    LogHolder.log(6, LogType.NET, "ForwardScheduler: handleNewConnection: New forwarding connection from " + Endpoint.toURN(a_newConnection.getRemoteAddress()) + " accepted.");
                    this.m_statistics.incrementAcceptedConnections();
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.NET, "ForwardScheduler: handleNewConnection: Error initializing protocol on forwarding connection from " + Endpoint.toURN(a_newConnection.getRemoteAddress()) + " (" + e.toString() + ").");
                }
            }
        }
        if (!connectionAccepted) {
            LogHolder.log(6, LogType.NET, "ForwardScheduler: handleNewConnection: New forwarding connection from " + Endpoint.toURN(a_newConnection.getRemoteAddress()) + " rejected (maximum number of connections is reached).");
            this.m_statistics.incrementRejectedConnections();
            try {
                a_newConnection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ForwardConnection a_connectionToRemove) {
        Vector vector = this.m_connectionHandler;
        synchronized (vector) {
            this.m_connectionHandler.removeElement(a_connectionToRemove);
        }
        LogHolder.log(6, LogType.NET, "ForwardScheduler: removeConnection: Forwarded connection from " + a_connectionToRemove.toString() + " was closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.m_shutdown = true;
        this.removeAllServerManagers();
        Vector vector = this.m_connectionHandler;
        synchronized (vector) {
            Enumeration connections = this.m_connectionHandler.elements();
            while (connections.hasMoreElements()) {
                ((ForwardConnection)connections.nextElement()).closeConnection();
            }
        }
        try {
            this.m_schedulerThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMaximumBandwidth() {
        return this.m_netBandwidth;
    }

    public int getGuaranteedBandwidth() {
        return this.m_netBandwidth / this.m_nrOfConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumNumberOfConnections(int a_maximumNumberOfConnections) {
        if (a_maximumNumberOfConnections >= 0) {
            if (a_maximumNumberOfConnections < this.m_nrOfConnections) {
                this.m_nrOfConnections = a_maximumNumberOfConnections;
                Vector vector = this.m_connectionHandler;
                synchronized (vector) {
                    while (this.m_connectionHandler.size() > this.m_nrOfConnections) {
                        try {
                            ((ForwardConnection)this.m_connectionHandler.elementAt((int)Math.round(Math.abs(Math.random() * (double)this.m_connectionHandler.size())))).closeConnection();
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    }
                }
            } else {
                this.m_nrOfConnections = a_maximumNumberOfConnections;
            }
        }
    }

    public void setNetBandwidth(int a_netBandwidth) {
        this.m_netBandwidth = a_netBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerManager(IServerManager a_serverManager) throws Exception {
        Hashtable hashtable = this.m_serverManagers;
        synchronized (hashtable) {
            if (!this.m_shutdown) {
                if (!this.m_serverManagers.containsKey(a_serverManager.getId())) {
                    a_serverManager.startServerManager(this);
                    this.m_serverManagers.put(a_serverManager.getId(), a_serverManager);
                } else {
                    throw new Exception("ForwardScheduler: addServerManager: Already a ServerManager with this ID running.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerManager(Object a_serverManagerId) {
        if (a_serverManagerId != null) {
            Hashtable hashtable = this.m_serverManagers;
            synchronized (hashtable) {
                IServerManager serverManagerToClose = (IServerManager)this.m_serverManagers.get(a_serverManagerId);
                if (serverManagerToClose != null) {
                    serverManagerToClose.shutdown();
                    this.m_serverManagers.remove(a_serverManagerId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllServerManagers() {
        Hashtable hashtable = this.m_serverManagers;
        synchronized (hashtable) {
            Enumeration serverManagers = this.m_serverManagers.elements();
            while (serverManagers.hasMoreElements()) {
                ((IServerManager)serverManagers.nextElement()).shutdown();
            }
            this.m_serverManagers.clear();
        }
    }

    public ForwardSchedulerStatistics getStatistics() {
        return this.m_statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentlyForwardedConnections() {
        int forwardedConnections = 0;
        Vector vector = this.m_connectionHandler;
        synchronized (vector) {
            forwardedConnections = this.m_connectionHandler.size();
        }
        return forwardedConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.m_shutdown) {
            Vector vector = this.m_connectionHandler;
            synchronized (vector) {
                int openConnections = this.m_connectionHandler.size();
                int[] readyBytes = new int[openConnections];
                Vector<Integer> connectionRanking = new Vector<Integer>();
                for (int i = 0; i < openConnections; ++i) {
                    int insertPos = 0;
                    for (int j = 0; j < i; ++j) {
                        if (readyBytes[j] >= readyBytes[i]) continue;
                        ++insertPos;
                    }
                    connectionRanking.insertElementAt(new Integer(i), insertPos);
                }
                int bytesPerRound = this.m_netBandwidth * 100 / 1000;
                if (openConnections > 0) {
                    int bytesPerConnection = bytesPerRound / openConnections;
                    for (int i = 0; i < openConnections; ++i) {
                        int currentConnection = (Integer)connectionRanking.elementAt(i);
                        ((ForwardConnection)this.m_connectionHandler.elementAt(currentConnection)).allowTransfer(bytesPerConnection);
                    }
                }
            }
            long nextWakeUp = (System.currentTimeMillis() / 100L + 1L) * 100L;
            long currentTime = System.currentTimeMillis();
            while (currentTime < nextWakeUp) {
                try {
                    Thread.sleep(nextWakeUp - currentTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                currentTime = System.currentTimeMillis();
            }
        }
    }
}

