/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.MultiCertPath;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractCertifiedDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.PerformanceEntry;
import anon.util.IXMLEncodable;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PerformanceInfo
extends AbstractCertifiedDatabaseEntry
implements IXMLEncodable {
    private static final double PERFORMANCE_INFO_MIN_PERCENTAGE_OF_VALID_ENTRIES = 0.6;
    private long m_lastUpdate;
    private long m_serial;
    private String m_id;
    private Element m_xmlData;
    private XMLSignature m_signature;
    private MultiCertPath m_certPath;
    private Hashtable m_entries = new Hashtable();
    public static final String XML_ATTR_ID = "id";
    public static final String XML_ELEMENT_NAME = "PerformanceInfo";
    public static final String XML_ELEMENT_CONTAINER_NAME = "PerformanceInfoList";
    public static final int PERFORMANCE_INFO_TTL = 518400000;
    static /* synthetic */ Class class$anon$infoservice$PerformanceInfo;

    public PerformanceInfo(Element a_info) throws XMLParseException {
        super(System.currentTimeMillis() + 518400000L);
        if (a_info == null) {
            throw new XMLParseException("Could not parse PerformanceInfo. Invalid document element.");
        }
        NodeList list = a_info.getElementsByTagName("PerformanceEntry");
        try {
            this.m_signature = SignatureVerifier.getInstance().getVerifiedXml(a_info, 2);
            if (this.m_signature != null) {
                this.m_certPath = this.m_signature.getMultiCertPath();
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.MISC, e);
        }
        this.m_id = XMLUtil.parseAttribute((Node)a_info, XML_ATTR_ID, "");
        if (!this.checkId()) {
            throw new XMLParseException("PerformanceInfo: invalid id");
        }
        for (int i = 0; i < list.getLength(); ++i) {
            PerformanceEntry entry = new PerformanceEntry((Element)list.item(i));
            this.m_entries.put(entry.getId(), entry);
        }
        this.m_serial = this.m_lastUpdate = XMLUtil.parseAttribute((Node)a_info, "lastUpdate", System.currentTimeMillis());
        this.m_xmlData = a_info;
    }

    public XMLSignature getSignature() {
        return this.m_signature;
    }

    public MultiCertPath getCertPath() {
        return this.m_certPath;
    }

    public boolean isVerified() {
        if (this.m_certPath != null) {
            return this.m_certPath.isVerified();
        }
        return false;
    }

    public boolean isValid() {
        if (this.m_certPath != null) {
            return this.m_certPath.isValid(new Date());
        }
        return false;
    }

    public String getId() {
        return this.m_id;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public long getVersionNumber() {
        return this.m_serial;
    }

    private PerformanceEntry getEntry(String a_id) {
        return (PerformanceEntry)this.m_entries.get(a_id);
    }

    public static PerformanceEntry getLowestCommonBoundEntry(String a_cascadeId) {
        PerformanceEntry.StabilityAttributes attributes;
        PerformanceEntry perfEntry = new PerformanceEntry(a_cascadeId, true);
        Vector<PerformanceEntry> vPerfEntries = new Vector<PerformanceEntry>();
        Vector<Integer> vSpeedBoundaries = new Vector<Integer>();
        Vector<Integer> vSpeedNotRecoveredBoundaries = new Vector<Integer>();
        Vector<Integer> vSpeedBestBoundaries = new Vector<Integer>();
        Vector<Integer> vDelayBoundaries = new Vector<Integer>();
        Vector<Integer> vDelayNotRecoveredBoundaries = new Vector<Integer>();
        Vector<Integer> vDelayBestBoundaries = new Vector<Integer>();
        Vector<Integer> vErrorBoundaries = new Vector<Integer>();
        Vector<Integer> vUnknownBoundaries = new Vector<Integer>();
        Vector<Integer> vResetsBoundaries = new Vector<Integer>();
        Vector vInfoServices = Database.getInstance(class$anon$infoservice$PerformanceInfo == null ? (class$anon$infoservice$PerformanceInfo = PerformanceInfo.class$("anon.infoservice.PerformanceInfo")) : class$anon$infoservice$PerformanceInfo).getEntryList();
        for (int i = 0; i < vInfoServices.size(); ++i) {
            PerformanceEntry entry = ((PerformanceInfo)vInfoServices.elementAt(i)).getEntry(a_cascadeId);
            if (entry == null) continue;
            vPerfEntries.addElement(entry);
            Integer value = new Integer(entry.getBound(0).getBound());
            if (value != Integer.MAX_VALUE && value >= 0) {
                vSpeedBoundaries.addElement(value);
            }
            if ((value = new Integer(entry.getBound(0).getNotRecoveredBound())) != Integer.MAX_VALUE && value >= 0) {
                vSpeedNotRecoveredBoundaries.addElement(value);
            }
            if ((value = new Integer(entry.getBound(1).getBound())) > 0) {
                vDelayBoundaries.addElement(value);
            }
            if ((value = new Integer(entry.getBound(1).getNotRecoveredBound())) > 0) {
                vDelayNotRecoveredBoundaries.addElement(value);
            }
            if ((value = new Integer(entry.getBestBound(0))) != Integer.MAX_VALUE && value >= 0) {
                vSpeedBestBoundaries.addElement(value);
            }
            if ((value = new Integer(entry.getBestBound(1))) > 0) {
                vDelayBestBoundaries.addElement(value);
            }
            if ((attributes = entry.getStabilityAttributes()).getValueSize() <= 0) continue;
            vErrorBoundaries.addElement(new Integer(attributes.getBoundErrors()));
            vUnknownBoundaries.addElement(new Integer(attributes.getBoundUnknown()));
            vResetsBoundaries.addElement(new Integer(attributes.getBoundResets()));
        }
        vInfoServices.removeAllElements();
        vInfoServices = null;
        if (vPerfEntries.size() == 0) {
            perfEntry.setBound(0, new PerformanceEntry.Bound(Integer.MAX_VALUE, Integer.MAX_VALUE));
            perfEntry.setBestBound(0, Integer.MAX_VALUE);
            perfEntry.setBound(1, new PerformanceEntry.Bound(0, 0));
            perfEntry.setBestBound(1, 0);
            perfEntry.setStabilityAttributes(new PerformanceEntry.StabilityAttributes(0, 0, 0, 0));
            return perfEntry;
        }
        Util.sort(vSpeedBoundaries, new Util.IntegerSortDesc());
        Util.sort(vSpeedNotRecoveredBoundaries, new Util.IntegerSortDesc());
        Util.sort(vSpeedBestBoundaries, new Util.IntegerSortDesc());
        Util.sort(vDelayBoundaries, new Util.IntegerSortAsc());
        Util.sort(vDelayNotRecoveredBoundaries, new Util.IntegerSortAsc());
        Util.sort(vDelayBestBoundaries, new Util.IntegerSortAsc());
        Util.sort(vErrorBoundaries, new Util.IntegerSortAsc());
        Util.sort(vUnknownBoundaries, new Util.IntegerSortAsc());
        Util.sort(vResetsBoundaries, new Util.IntegerSortAsc());
        attributes = new PerformanceEntry.StabilityAttributes(100, PerformanceInfo.getMajorityBoundFromSortedBounds(vUnknownBoundaries, 0), PerformanceInfo.getMajorityBoundFromSortedBounds(vErrorBoundaries, 0), PerformanceInfo.getMajorityBoundFromSortedBounds(vResetsBoundaries, 0));
        perfEntry.setBound(0, new PerformanceEntry.Bound(PerformanceInfo.getMajorityBoundFromSortedBounds(vSpeedBoundaries, Integer.MAX_VALUE), PerformanceInfo.getMajorityBoundFromSortedBounds(vSpeedNotRecoveredBoundaries, Integer.MAX_VALUE)));
        perfEntry.setBestBound(0, PerformanceInfo.getMajorityBoundFromSortedBounds(vSpeedBestBoundaries, Integer.MAX_VALUE));
        perfEntry.setBound(1, new PerformanceEntry.Bound(PerformanceInfo.getMajorityBoundFromSortedBounds(vDelayBoundaries, 0), PerformanceInfo.getMajorityBoundFromSortedBounds(vDelayNotRecoveredBoundaries, 0)));
        perfEntry.setBestBound(1, PerformanceInfo.getMajorityBoundFromSortedBounds(vDelayBestBoundaries, 0));
        perfEntry.setStabilityAttributes(attributes);
        return perfEntry;
    }

    private static int getMajorityBoundFromSortedBounds(Vector a_vecSortedIntegers, int a_default) {
        int bound = a_default;
        for (int i = 0; i < a_vecSortedIntegers.size(); ++i) {
            bound = (Integer)a_vecSortedIntegers.elementAt(i);
            if ((double)(i + 1) / (double)a_vecSortedIntegers.size() >= 0.6) break;
        }
        return bound;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_xmlData, true);
        }
        catch (XMLParseException ex) {
            LogHolder.log(2, LogType.NET, "Could not store PerformanceInfo to XML element", ex);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

