/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice.update;

import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLBalance;
import anon.util.Updater;
import java.util.Enumeration;
import logging.LogHolder;
import logging.LogType;

public class AccountUpdater
extends Updater {
    private boolean m_successfulUpdate = false;
    private long m_lLastUpdate = Long.MAX_VALUE;
    private boolean m_bInternalCalculation;
    static /* synthetic */ Class class$anon$pay$xml$XMLAccountInfo;

    public AccountUpdater(final boolean a_bInternalCalculation) {
        super(new Updater.IUpdateInterval(){

            public long getUpdateInterval() {
                return 900000L;
            }
        }, new Updater.ObservableInfo(PayAccountsFile.getInstance()){

            public Integer getUpdateChanged() {
                return PayAccountsFile.CHANGED_AUTO_UPDATE;
            }

            public boolean isUpdateDisabled() {
                if (a_bInternalCalculation) {
                    return PayAccountsFile.getInstance().isBalanceAutoUpdateEnabled();
                }
                return !PayAccountsFile.getInstance().isBalanceAutoUpdateEnabled();
            }

            public boolean updateImmediately() {
                return true;
            }
        });
        this.m_bInternalCalculation = a_bInternalCalculation;
    }

    public Class getUpdatedClass() {
        return class$anon$pay$xml$XMLAccountInfo == null ? (class$anon$pay$xml$XMLAccountInfo = AccountUpdater.class$("anon.pay.xml.XMLAccountInfo")) : class$anon$pay$xml$XMLAccountInfo;
    }

    protected void updateInternal() {
        this.m_successfulUpdate = false;
        if (Thread.currentThread().isInterrupted()) {
            this.m_successfulUpdate = true;
            return;
        }
        Enumeration accounts = PayAccountsFile.getInstance().getAccounts();
        boolean bTried = false;
        while (accounts.hasMoreElements() && !Thread.currentThread().isInterrupted()) {
            PayAccount account = (PayAccount)accounts.nextElement();
            try {
                XMLAccountInfo accountInfo;
                if (!this.m_bInternalCalculation && account.shouldUpdateAccountInfo()) {
                    bTried = true;
                    LogHolder.log(7, LogType.PAY, "Fetching statement for account: " + account.getAccountNumber());
                    accountInfo = account.fetchAccountInfo(false);
                    if (accountInfo == null) continue;
                    this.m_successfulUpdate = true;
                    this.m_lLastUpdate = System.currentTimeMillis();
                    continue;
                }
                if (!this.m_bInternalCalculation || (accountInfo = account.getAccountInfo()) == null) continue;
                XMLBalance balance = accountInfo.getBalance();
                if (!(account.hasExpired() || balance == null || account.getCurrentSpent() >= 0L && (balance.getVolumeBytesMonthly() <= 0L || balance.getOverusageDate() == null && accountInfo.getLastBalanceUpdateLocalTime().getTime() <= System.currentTimeMillis()))) {
                    accountInfo = account.fetchAccountInfo(true);
                    if (accountInfo == null) continue;
                    this.m_successfulUpdate = true;
                    this.m_lLastUpdate = System.currentTimeMillis();
                    continue;
                }
                accountInfo.checkMonthlyBytesUpdatedOn();
                this.m_successfulUpdate = true;
                this.m_lLastUpdate = System.currentTimeMillis();
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.PAY, "Could not fetch statement for account: " + account.getAccountNumber(), e);
                if (account.getAccountInfo() == null) continue;
                account.getAccountInfo().checkMonthlyBytesUpdatedOn();
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            this.m_successfulUpdate = true;
            return;
        }
        if (PayAccountsFile.getInstance().getNumAccounts() == 0) {
            this.m_successfulUpdate = true;
        } else if (!this.m_bInternalCalculation && !bTried) {
            this.m_successfulUpdate = true;
        }
    }

    public final long getLastUpdate() {
        return this.m_lLastUpdate;
    }

    protected boolean wasUpdateSuccessful() {
        return this.m_successfulUpdate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

