/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLExternalChargeRequest
implements IXMLEncodable {
    private Vector m_chargeRequest = new Vector();
    private String m_password;

    public XMLExternalChargeRequest() {
    }

    public XMLExternalChargeRequest(String xml) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xml);
        this.setValues(doc.getDocumentElement());
    }

    public XMLExternalChargeRequest(char[] xml) throws Exception {
        this(new String(xml));
    }

    public XMLExternalChargeRequest(byte[] xml) throws Exception {
        this.setValues(XMLUtil.toXMLDocument(xml).getDocumentElement());
    }

    public XMLExternalChargeRequest(Document a_doc) {
        try {
            this.setValues(a_doc.getDocumentElement());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPassword(String a_password) {
        this.m_password = a_password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void addCharge(String a_tan, String a_currency, String a_amount) {
        this.m_chargeRequest.addElement(new String[]{a_tan, a_currency, a_amount});
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement("ExternalChargeRequest");
        Element elem = a_doc.createElement("Password");
        elem.appendChild(a_doc.createTextNode(this.m_password));
        elemRoot.appendChild(elem);
        for (int i = 0; i < this.m_chargeRequest.size(); ++i) {
            String[] charge = (String[])this.m_chargeRequest.elementAt(i);
            Element elemCharge = a_doc.createElement("Charge");
            elem = a_doc.createElement("TransferNumber");
            elem.appendChild(a_doc.createTextNode(charge[0]));
            elemCharge.appendChild(elem);
            elem = a_doc.createElement("Currency");
            elem.appendChild(a_doc.createTextNode(charge[1]));
            elemCharge.appendChild(elem);
            elem = a_doc.createElement("Amount");
            elem.appendChild(a_doc.createTextNode(charge[2]));
            elemCharge.appendChild(elem);
            elemRoot.appendChild(elemCharge);
        }
        return elemRoot;
    }

    protected void setValues(Element elemRoot) throws Exception {
        if (!elemRoot.getTagName().equals("ExternalChargeRequest")) {
            throw new Exception("ExternalChargeRequest wrong XML structure");
        }
        Node pw = XMLUtil.getFirstChildByName(elemRoot, "Password");
        if (pw != null) {
            this.m_password = XMLUtil.parseValue(pw, "");
        }
        NodeList charges = elemRoot.getElementsByTagName("Charge");
        for (int i = 0; i < charges.getLength(); ++i) {
            String tan = "";
            String currency = "";
            String amount = "";
            Node n = XMLUtil.getFirstChildByName(charges.item(i), "TransferNumber");
            if (n != null) {
                tan = XMLUtil.parseValue(n, "");
            }
            if ((n = XMLUtil.getFirstChildByName(charges.item(i), "Currency")) != null) {
                currency = XMLUtil.parseValue(n, "");
            }
            if ((n = XMLUtil.getFirstChildByName(charges.item(i), "Amount")) != null) {
                amount = XMLUtil.parseValue(n, "");
            }
            this.addCharge(tan, currency, amount);
        }
    }

    public Enumeration getChargeLines() {
        return this.m_chargeRequest.elements();
    }
}

