/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLTransferRequest
implements IXMLEncodable {
    private int m_requested;
    private String m_operatorCert;
    private Document m_docTheRequest;
    private static String ms_strElemName = "TransferRequest";

    public XMLTransferRequest(int a_requested) {
        this.m_requested = a_requested;
        this.m_docTheRequest = XMLUtil.createDocument();
        this.m_docTheRequest.appendChild(this.internal_toXmlElement(this.m_docTheRequest));
    }

    public XMLTransferRequest(int a_requested, String a_operator) {
        this.m_requested = a_requested;
        this.m_operatorCert = a_operator;
        this.m_docTheRequest = XMLUtil.createDocument();
        this.m_docTheRequest.appendChild(this.internal_toXmlElement(this.m_docTheRequest));
    }

    public XMLTransferRequest(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheRequest = doc;
    }

    public XMLTransferRequest(char[] xmldata) throws Exception {
        this(new String(xmldata));
    }

    public XMLTransferRequest(byte[] xmldata) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xmldata);
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheRequest = doc;
    }

    public XMLTransferRequest(Element xml) throws Exception {
        this.setValues(xml);
        this.m_docTheRequest = XMLUtil.createDocument();
        this.m_docTheRequest.appendChild(XMLUtil.importNode(this.m_docTheRequest, xml, true));
    }

    public XMLTransferRequest(Document xml) throws Exception {
        Element elemRoot = xml.getDocumentElement();
        this.setValues(elemRoot);
        this.m_docTheRequest = xml;
    }

    private void setValues(Element xml) throws Exception {
        if (!xml.getTagName().equals("TransferRequest")) {
            throw new Exception("XMLTransferRequest: cannot parse, wrong xml format!");
        }
        if (!xml.getAttribute("version").equals("1.0")) {
            throw new Exception("XMLTransferRequest: cannot parse, cert version is " + xml.getAttribute("version") + " but 1.0 was expected.");
        }
        Element elem = (Element)XMLUtil.getFirstChildByName(xml, "Requested");
        this.m_requested = XMLUtil.parseValue((Node)elem, 0);
        if (this.m_requested == 0) {
            throw new Exception("XMLTransferRequest: cannot parse requested");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "Operator");
        this.m_operatorCert = XMLUtil.parseValue((Node)elem, "none");
        if (this.m_operatorCert.equals("none")) {
            throw new Exception("no operator cert set in XMLTransferRequest");
        }
    }

    public int getRequested() {
        return this.m_requested;
    }

    public String getOperatorCert() {
        return this.m_operatorCert;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheRequest.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(ms_strElemName);
        elemRoot.setAttribute("version", "1.0");
        Element elem = a_doc.createElement("Requested");
        XMLUtil.setValue((Node)elem, this.m_requested);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Operator");
        XMLUtil.setValue((Node)elem, this.m_operatorCert);
        elemRoot.appendChild(elem);
        return elemRoot;
    }
}

