/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import java.io.UnsupportedEncodingException;

public class URLCoder {
    static final String digits = "0123456789ABCDEF";

    public static String decode(String a_strURL) {
        if (a_strURL == null) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        byte[] enc = new byte[a_strURL.length()];
        int bytes = 0;
        int i = 0;
        try {
            while (i < a_strURL.length()) {
                char c = a_strURL.charAt(i);
                if (c == '+') {
                    output.append(' ');
                } else if (c == '%') {
                    enc[bytes] = (byte)Integer.parseInt(a_strURL.substring(i + 1, i + 3), 16);
                    ++bytes;
                    i += 2;
                } else {
                    output.append(c);
                }
                if ((++i >= a_strURL.length() || a_strURL.charAt(i) == '%') && i < a_strURL.length()) continue;
                output.append(new String(enc, 0, bytes, "UTF8"));
                bytes = 0;
            }
        }
        catch (NumberFormatException a_e) {
            return null;
        }
        catch (UnsupportedEncodingException a_e) {
            return null;
        }
        return output.toString();
    }

    public static String encode(String s) throws UnsupportedEncodingException {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(s.length() + 16);
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || " .-*_".indexOf(ch) > -1) {
                if (start >= 0) {
                    URLCoder.convert(s.substring(start, i), buf);
                    start = -1;
                }
                if (ch != ' ') {
                    buf.append(ch);
                    continue;
                }
                buf.append('+');
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            URLCoder.convert(s.substring(start, s.length()), buf);
        }
        return buf.toString();
    }

    private static void convert(String s, StringBuffer buf) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes("UTF8");
        for (int j = 0; j < bytes.length; ++j) {
            buf.append('%');
            buf.append(digits.charAt((bytes[j] & 0xF0) >> 4));
            buf.append(digits.charAt(bytes[j] & 0xF));
        }
    }
}

