/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.IProgressCapsule;
import anon.util.RecursiveFileTool;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import logging.LogHolder;
import logging.LogType;

public class ZipArchiver
extends Observable {
    private ZipFile m_archive;

    public ZipArchiver(ZipFile archive) {
        this.m_archive = archive;
    }

    public int applyDiff(File fileNewJAR, byte[] diffJAR) {
        try {
            ZipFile zold = this.m_archive;
            ZipInputStream zdiff = null;
            ZipOutputStream znew = null;
            ZipEntry ze = null;
            long totalSize = diffJAR.length;
            Hashtable<String, String> oldnames = new Hashtable<String, String>();
            Enumeration<ZipEntry> e = zold.entries();
            while (e.hasMoreElements()) {
                if (Thread.currentThread().isInterrupted()) {
                    return -1;
                }
                ze = e.nextElement();
                totalSize += ze.getSize();
                oldnames.put(ze.getName(), ze.getName());
            }
            zdiff = new ZipInputStream(new ByteArrayInputStream(diffJAR));
            znew = new ZipOutputStream(new FileOutputStream(fileNewJAR));
            znew.setLevel(9);
            byte[] b = new byte[5000];
            long sizeOfCopied = 0L;
            while ((ze = zdiff.getNextEntry()) != null) {
                if (Thread.currentThread().isInterrupted()) {
                    znew.close();
                    return -1;
                }
                ZipEntry zeout = new ZipEntry(ze.getName());
                if (!ze.getName().equalsIgnoreCase("META-INF/INDEX.JD")) {
                    LogHolder.log(7, LogType.MISC, "JARDiff: " + ze.getName());
                    oldnames.remove(ze.getName());
                    int s = -1;
                    zeout.setTime(ze.getTime());
                    zeout.setComment(ze.getComment());
                    zeout.setExtra(ze.getExtra());
                    zeout.setMethod(ze.getMethod());
                    if (ze.getSize() != -1L) {
                        zeout.setSize(ze.getSize());
                    }
                    if (ze.getCrc() != -1L) {
                        zeout.setCrc(ze.getCrc());
                    }
                    znew.putNextEntry(zeout);
                    while ((s = zdiff.read(b, 0, 5000)) != -1) {
                        znew.write(b, 0, s);
                        this.notifyAboutChangesInterruptable(sizeOfCopied += (long)s, totalSize, 1);
                    }
                    znew.closeEntry();
                } else {
                    BufferedReader br = new BufferedReader(new InputStreamReader(zdiff));
                    String s = null;
                    while ((s = br.readLine()) != null) {
                        if (Thread.currentThread().isInterrupted()) {
                            return -1;
                        }
                        StringTokenizer st = new StringTokenizer(s);
                        if ((s = st.nextToken()).equalsIgnoreCase("remove")) {
                            s = st.nextToken();
                            LogHolder.log(7, LogType.MISC, "JARDiff: remove " + s);
                            oldnames.remove(s);
                            continue;
                        }
                        if (s.equalsIgnoreCase("move")) {
                            LogHolder.log(7, LogType.MISC, "JARDiff: move " + st.nextToken());
                            continue;
                        }
                        LogHolder.log(7, LogType.MISC, "JARDiff: unkown: " + s);
                    }
                }
                zdiff.closeEntry();
            }
            e = oldnames.elements();
            while (e.hasMoreElements()) {
                String s = (String)((Object)e.nextElement());
                LogHolder.log(7, LogType.MISC, s);
                ze = zold.getEntry(s);
                ZipEntry zeout = new ZipEntry(ze.getName());
                zeout.setTime(ze.getTime());
                zeout.setComment(ze.getComment());
                zeout.setExtra(ze.getExtra());
                zeout.setMethod(ze.getMethod());
                if (ze.getSize() != -1L) {
                    zeout.setSize(ze.getSize());
                }
                if (ze.getCrc() != -1L) {
                    zeout.setCrc(ze.getCrc());
                }
                znew.putNextEntry(zeout);
                LogHolder.log(7, LogType.MISC, "JARDiff: Getting in..");
                InputStream in = zold.getInputStream(ze);
                int l = -1;
                LogHolder.log(7, LogType.MISC, "JARDiff: Reading..");
                try {
                    while ((l = in.read(b, 0, 5000)) != -1) {
                        znew.write(b, 0, l);
                        this.notifyAboutChangesInterruptable(sizeOfCopied += (long)l, totalSize, 1);
                    }
                }
                catch (Exception er) {
                    LogHolder.log(2, LogType.MISC, er);
                }
                in.close();
                znew.closeEntry();
            }
            znew.finish();
            znew.flush();
            znew.close();
            zold.close();
            zdiff.close();
        }
        catch (Throwable e) {
            LogHolder.log(2, LogType.MISC, e);
            return -1;
        }
        return 0;
    }

    public boolean extractSingleEntry(String entryName, String destinationName) {
        try {
            ZipEntry entry = this.m_archive.getEntry(entryName);
            if (entry == null) {
                LogHolder.log(3, LogType.MISC, "Entry " + entryName + " not found.");
                return false;
            }
            RecursiveFileTool.copySingleFile(this.m_archive.getInputStream(entry), new File(destinationName));
            return true;
        }
        catch (IOException ioe) {
            LogHolder.log(3, LogType.MISC, "Extracting entry " + entryName + " failed", ioe);
            return false;
        }
    }

    public boolean extractArchive(String a_archivePathName, String destination) {
        String dest = destination;
        Enumeration<? extends ZipEntry> allZipEntries = null;
        Vector<ZipEntry> matchedFileEntries = new Vector<ZipEntry>();
        Vector<String> matchedDirEntries = new Vector<String>();
        Vector<String> extractedFiles = new Vector<String>();
        ZipEntry entry = null;
        String entryName = null;
        int index = 0;
        int dirIndex = 0;
        int fileIndex = 0;
        long totalSize = 0L;
        long sizeOfCopied = 0L;
        if (this.m_archive == null) {
            LogHolder.log(3, LogType.MISC, "Archive is null");
            return false;
        }
        if (destination == null) {
            LogHolder.log(3, LogType.MISC, "Error while extracting archive " + this.m_archive.getName() + ": destination address is null");
            return false;
        }
        try {
            allZipEntries = this.m_archive.entries();
            while (allZipEntries.hasMoreElements() && !Thread.currentThread().isInterrupted()) {
                entry = allZipEntries.nextElement();
                entryName = entry.getName();
                if (a_archivePathName != null && !entryName.startsWith(a_archivePathName)) continue;
                totalSize += entry.getSize();
                if (entry.isDirectory()) {
                    for (index = 0; index < matchedDirEntries.size() && ((String)matchedDirEntries.elementAt(index)).compareTo(entryName) <= 0; ++index) {
                    }
                    matchedDirEntries.insertElementAt(entryName, index);
                    continue;
                }
                matchedFileEntries.addElement(entry);
            }
            if (matchedFileEntries.size() == 0 && matchedDirEntries.size() == 0) {
                LogHolder.log(3, LogType.MISC, "No matching files for " + a_archivePathName + " found in archive " + this.m_archive.getName());
                this.notifyAboutChanges(0L, 0L, 3);
                return false;
            }
            Enumeration iterator = matchedDirEntries.elements();
            while (iterator.hasMoreElements() && !Thread.currentThread().isInterrupted()) {
                String dirName = (String)iterator.nextElement();
                File dir = new File(dest + File.separator + dirName);
                if (dir != null) {
                    if (!dir.exists() && !dir.mkdir()) {
                        LogHolder.log(3, LogType.MISC, "Error while extracting archive " + this.m_archive.getName() + ": could not create directory " + dir.getAbsolutePath());
                        ZipArchiver.extractErrorRollback(matchedDirEntries, destination);
                        return false;
                    }
                    extractedFiles.addElement(dirName);
                }
                ++dirIndex;
            }
            this.notifyAboutChangesInterruptable(sizeOfCopied, totalSize, 1);
            iterator = matchedFileEntries.elements();
            while (iterator.hasMoreElements() && !Thread.currentThread().isInterrupted()) {
                ZipEntry zEntry = (ZipEntry)iterator.nextElement();
                File destFile = new File(dest + File.separator + zEntry.getName());
                InputStream zEntryInputStream = this.m_archive.getInputStream(zEntry);
                RecursiveFileTool.copySingleFile(zEntryInputStream, destFile);
                extractedFiles.addElement(zEntry.getName());
                this.notifyAboutChangesInterruptable(sizeOfCopied += zEntry.getSize(), totalSize, 1);
                ++fileIndex;
            }
        }
        catch (IllegalStateException ise) {
            LogHolder.log(3, LogType.MISC, "Cannot extract archive " + this.m_archive.getName() + ": file already closed");
            this.notifyAboutChanges(sizeOfCopied, totalSize, 3);
            return false;
        }
        catch (InterruptedIOException ioe) {
            LogHolder.log(7, LogType.MISC, "Process of extracting " + this.m_archive.getName() + " cancelled");
            ZipArchiver.extractErrorRollback(extractedFiles, destination);
            this.notifyAboutChanges(sizeOfCopied, totalSize, 2);
            return false;
        }
        catch (InterruptedException e) {
            LogHolder.log(7, LogType.MISC, "Process of extracting " + this.m_archive.getName() + " cancelled");
            ZipArchiver.extractErrorRollback(extractedFiles, destination);
            this.notifyAboutChanges(sizeOfCopied, totalSize, 2);
            return false;
        }
        catch (Exception a_e) {
            LogHolder.log(3, LogType.MISC, "Cannot extract archive " + this.m_archive.getName() + ": error occured: ", a_e);
            ZipArchiver.extractErrorRollback(extractedFiles, destination);
            this.notifyAboutChanges(sizeOfCopied, totalSize, 3);
            return false;
        }
        this.notifyAboutChanges(sizeOfCopied, totalSize, 0);
        return true;
    }

    private void notifyAboutChanges(long sizeOfCopied, long totalSize, int progressStatus) {
        ZipEvent ze = new ZipEvent(sizeOfCopied, totalSize, progressStatus);
        this.setChanged();
        this.notifyObservers(ze);
    }

    private void notifyAboutChangesInterruptable(long sizeOfCopied, long totalSize, int progressStatus) throws InterruptedException {
        this.notifyAboutChanges(sizeOfCopied, totalSize, progressStatus);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private static void extractErrorRollback(Vector entries, String destination) {
        for (int i = entries.size(); i > 0; --i) {
            File f = new File(destination + File.separator + entries.elementAt(i - 1));
            if (!f.exists()) continue;
            String was = f.delete() ? " " : " not ";
            LogHolder.log(was.trim().length() == 0 ? 7 : 3, LogType.MISC, "Rollback: file " + f.getAbsolutePath() + was + "successfully deleted");
        }
    }

    public class ZipEvent
    implements IProgressCapsule {
        private int value;
        private int maxValue;
        private int minValue = 0;
        private int status;

        public ZipEvent(long byteCount, long totalByteCount, int progressStatus) {
            if (totalByteCount > Integer.MAX_VALUE) {
                double byteCountD = byteCount;
                double totalByteCountD = totalByteCount;
                double ratio = byteCountD / totalByteCountD;
                double valueD = ratio * 2.147483647E9;
                this.value = (int)valueD;
                this.maxValue = Integer.MAX_VALUE;
            } else {
                this.value = (int)byteCount;
                this.maxValue = (int)totalByteCount;
            }
            this.status = progressStatus;
        }

        public void reset() {
        }

        public int getMaximum() {
            return this.maxValue;
        }

        public int getMinimum() {
            return this.minValue;
        }

        public int getValue() {
            return this.value;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return null;
        }
    }
}

