/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.infoservice.Database;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.JAPVersionInfo;
import anon.infoservice.JavaVersionDBEntry;
import anon.platform.AbstractOS;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.dialog.JAPDialog;
import jap.AbstractJAPConfModule;
import jap.JAPConstants;
import jap.JAPController;
import jap.JAPModel;
import jap.SoftwareUpdater;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import logging.LogHolder;
import logging.LogType;
import update.JAPUpdateWizard;

final class JAPConfUpdate
extends AbstractJAPConfModule
implements ActionListener,
ItemListener,
Runnable,
Observer {
    public static final String MSG_DO_EXTERNAL_UPDATE = (class$jap$JAPConfUpdate == null ? (class$jap$JAPConfUpdate = JAPConfUpdate.class$("jap.JAPConfUpdate")) : class$jap$JAPConfUpdate).getName() + ".doExternalUpdate";
    private static final String COMMAND_UPGRADE = "UPGRADE";
    private static final String COMMAND_CHECKFORUPGRADE = "CHECKFORUPGRADE";
    private static final String MSG_ALLOW_DIRECT_CONN = (class$jap$JAPConfUpdate == null ? (class$jap$JAPConfUpdate = JAPConfUpdate.class$("jap.JAPConfUpdate")) : class$jap$JAPConfUpdate).getName() + "_allowDirectConnection";
    private static final String MSG_REMIND_OPTIONAL_UPDATE = (class$jap$JAPConfUpdate == null ? (class$jap$JAPConfUpdate = JAPConfUpdate.class$("jap.JAPConfUpdate")) : class$jap$JAPConfUpdate).getName() + "_remindOptionalUpdate";
    private static final String MSG_REMIND_JAVA_UPDATE = (class$jap$JAPConfUpdate == null ? (class$jap$JAPConfUpdate = JAPConfUpdate.class$("jap.JAPConfUpdate")) : class$jap$JAPConfUpdate).getName() + "_remindJavaUpdate";
    private static final String MSG_INFO = (class$jap$JAPConfUpdate == null ? (class$jap$JAPConfUpdate = JAPConfUpdate.class$("jap.JAPConfUpdate")) : class$jap$JAPConfUpdate).getName() + "_info";
    private JTextArea m_taInfo;
    private JScrollPane m_taInfoScrollPane;
    private JLabel m_labelVersion;
    private JLabel m_labelDate;
    private JComboBox m_comboType;
    private JButton m_bttnUpgrade;
    private JButton m_bttnCheckForUpgrade;
    private JComboBox m_comboAnonymousConnection;
    private JCheckBox m_cbxRemindOptionalUpdate;
    private JCheckBox m_cbxRemindJavaUpdate;
    private Thread m_threadGetVersionInfo;
    private JAPVersionInfo m_devVersion;
    private JAPVersionInfo m_releaseVersion;
    private DateFormat m_DateFormat;
    static /* synthetic */ Class class$jap$JAPConfUpdate;
    static /* synthetic */ Class class$anon$infoservice$JAPVersionInfo;

    public JAPConfUpdate() {
        super(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initObservers() {
        if (super.initObservers()) {
            Object object = this.LOCK_OBSERVABLE;
            synchronized (object) {
                JAPModel.getInstance().addObserver(this);
                return true;
            }
        }
        return false;
    }

    public void recreateRootPanel() {
        JPanel panelRoot = this.getRootPanel();
        panelRoot.removeAll();
        GridBagLayout gridBagFrame = new GridBagLayout();
        panelRoot.setLayout(gridBagFrame);
        JPanel buttonPanel = new JPanel();
        GridBagLayout gridBagPanel = new GridBagLayout();
        buttonPanel.setLayout(gridBagPanel);
        GridBagConstraints cButtons = new GridBagConstraints();
        cButtons.gridx = -1;
        cButtons.weightx = 1.0;
        cButtons.weighty = 1.0;
        cButtons.fill = 3;
        cButtons.anchor = 17;
        this.m_bttnUpgrade = new JButton(JAPMessages.getString("confUpgrade"));
        this.m_bttnUpgrade.addActionListener(this);
        this.m_bttnUpgrade.setActionCommand(COMMAND_UPGRADE);
        cButtons.anchor = 10;
        cButtons.gridx = 1;
        gridBagPanel.setConstraints(this.m_bttnUpgrade, cButtons);
        this.m_bttnUpgrade.setEnabled(false);
        buttonPanel.add(this.m_bttnUpgrade);
        this.m_bttnCheckForUpgrade = new JButton(JAPMessages.getString("confCheckForUpgrade"));
        this.m_bttnCheckForUpgrade.setIcon(GUIUtils.loadImageIcon("reload.gif", true, false));
        this.m_bttnCheckForUpgrade.setDisabledIcon(GUIUtils.loadImageIcon("reloaddisabled_anim.gif", true, false));
        this.m_bttnCheckForUpgrade.setPressedIcon(GUIUtils.loadImageIcon("reloadrollover.gif", true, false));
        this.m_bttnCheckForUpgrade.addActionListener(this);
        this.m_bttnCheckForUpgrade.setActionCommand(COMMAND_CHECKFORUPGRADE);
        cButtons.anchor = 10;
        cButtons.gridx = 0;
        gridBagPanel.setConstraints(this.m_bttnCheckForUpgrade, cButtons);
        this.m_bttnCheckForUpgrade.setEnabled(true);
        buttonPanel.add(this.m_bttnCheckForUpgrade);
        gridBagPanel = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        TitledBorder titledBorder = new TitledBorder(" " + JAPMessages.getString("updateTitleBorderInstalled") + " ");
        JPanel installedPanel = new JPanel(gridBagPanel);
        installedPanel.setBorder(titledBorder);
        JLabel l = new JLabel("Version: ");
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.weighty = 0.33;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        gridBagPanel.setConstraints(l, c);
        installedPanel.add(l);
        l = new JLabel("00.20.010");
        c.gridx = 1;
        c.fill = 1;
        c.weightx = 1.0;
        gridBagPanel.setConstraints(l, c);
        installedPanel.add(l);
        l = new JLabel(JAPMessages.getString("updateLabelDate") + " ");
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.fill = 0;
        gridBagPanel.setConstraints(l, c);
        installedPanel.add(l);
        String strDate = JAPConstants.strReleaseDate;
        try {
            Date d;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
            try {
                d = sdf.parse(strDate + " GMT");
            }
            catch (ParseException a_e) {
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                d = sdf.parse(strDate + " GMT");
            }
            this.m_DateFormat = DateFormat.getDateTimeInstance(2, 2);
            strDate = this.m_DateFormat.format(d);
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.MISC, e);
        }
        l = new JLabel(strDate);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 1;
        gridBagPanel.setConstraints(l, c);
        installedPanel.add(l);
        l = new JLabel(JAPMessages.getString("updateType") + ": ");
        c.gridy = 2;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        gridBagPanel.setConstraints(l, c);
        installedPanel.add(l);
        l = new JLabel(JAPMessages.getString("updateDevelopmentVersion"));
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 1;
        gridBagPanel.setConstraints(l, c);
        installedPanel.add(l);
        gridBagPanel = new GridBagLayout();
        titledBorder = new TitledBorder(" " + JAPMessages.getString("updateTitleBorderLatest") + " ");
        JPanel latestPanel = new JPanel(gridBagPanel);
        latestPanel.setBorder(titledBorder);
        l = new JLabel("Version: ");
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        gridBagPanel.setConstraints(l, c);
        latestPanel.add(l);
        this.m_labelVersion = new JLabel(JAPMessages.getString("updateUnknown"));
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 1;
        gridBagPanel.setConstraints(this.m_labelVersion, c);
        latestPanel.add(this.m_labelVersion);
        l = new JLabel(JAPMessages.getString("updateLabelDate") + " ");
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        gridBagPanel.setConstraints(l, c);
        latestPanel.add(l);
        this.m_labelDate = new JLabel(JAPMessages.getString("updateUnknown"));
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 1;
        gridBagPanel.setConstraints(this.m_labelDate, c);
        latestPanel.add(this.m_labelDate);
        l = new JLabel(JAPMessages.getString("updateType") + ": ");
        c.gridy = 2;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        gridBagPanel.setConstraints(l, c);
        latestPanel.add(l);
        this.m_comboType = new JComboBox();
        this.m_comboType.addItem(JAPMessages.getString("updateReleaseVersion"));
        this.m_comboType.addItem(JAPMessages.getString("updateDevelopmentVersion"));
        this.m_comboType.setSelectedIndex(1);
        this.m_comboType.setEnabled(false);
        this.m_comboType.addItemListener(this);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 1;
        gridBagPanel.setConstraints(this.m_comboType, c);
        latestPanel.add(this.m_comboType);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.m_taInfo = new JTextArea();
        this.m_taInfo.setEditable(false);
        this.m_taInfo.setHighlighter(null);
        this.m_taInfoScrollPane = new JScrollPane(this.m_taInfo);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 18;
        infoPanel.add((Component)new JLabel(JAPMessages.getString(MSG_INFO)), constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(10, 0, 0, 0);
        infoPanel.add((Component)this.m_taInfoScrollPane, constraints);
        GridBagConstraints cFrame = new GridBagConstraints();
        cFrame.insets = new Insets(10, 10, 10, 10);
        cFrame.gridx = 0;
        cFrame.gridy = 0;
        cFrame.weightx = 0.0;
        cFrame.weighty = 0.0;
        cFrame.anchor = 18;
        cFrame.fill = 1;
        gridBagFrame.setConstraints(installedPanel, cFrame);
        panelRoot.add(installedPanel);
        cFrame.gridx = 1;
        cFrame.gridy = 0;
        panelRoot.add((Component)latestPanel, cFrame);
        cFrame.gridx = 0;
        cFrame.gridy = 2;
        cFrame.gridwidth = 2;
        JPanel pnlAnonymousConnection = new JPanel();
        pnlAnonymousConnection.add(new JLabel(JAPMessages.getString(MSG_ALLOW_DIRECT_CONN) + ":"));
        String[] choiceAnonConnection = new String[JAPModel.getMsgConnectionAnonymous().length];
        System.arraycopy(JAPModel.getMsgConnectionAnonymous(), 0, choiceAnonConnection, 0, choiceAnonConnection.length);
        for (int i = 0; i < choiceAnonConnection.length; ++i) {
            choiceAnonConnection[i] = JAPMessages.getString(choiceAnonConnection[i]);
        }
        this.m_comboAnonymousConnection = new JComboBox<String>(choiceAnonConnection);
        pnlAnonymousConnection.add(this.m_comboAnonymousConnection);
        cFrame.fill = 0;
        panelRoot.add((Component)pnlAnonymousConnection, cFrame);
        ++cFrame.gridy;
        this.m_cbxRemindOptionalUpdate = new JCheckBox(JAPMessages.getString(MSG_REMIND_OPTIONAL_UPDATE));
        panelRoot.add((Component)this.m_cbxRemindOptionalUpdate, cFrame);
        ++cFrame.gridy;
        this.m_cbxRemindJavaUpdate = new JCheckBox(JAPMessages.getString(MSG_REMIND_JAVA_UPDATE));
        if (JAPController.getInstance().hasPortableJava()) {
            this.m_cbxRemindJavaUpdate.setEnabled(false);
        }
        panelRoot.add((Component)this.m_cbxRemindJavaUpdate, cFrame);
        ++cFrame.gridy;
        cFrame.anchor = 10;
        cFrame.fill = 1;
        cFrame.weightx = 1.0;
        cFrame.weighty = 1.0;
        gridBagFrame.setConstraints(infoPanel, cFrame);
        panelRoot.add(infoPanel);
        ++cFrame.gridy;
        cFrame.weighty = 0.0;
        cFrame.fill = 2;
        cFrame.anchor = 15;
        gridBagFrame.setConstraints(buttonPanel, cFrame);
        panelRoot.add(buttonPanel);
        this.updateValues(false);
    }

    public void update(Observable a_notifier, Object a_message) {
        if (a_message != null) {
            if (a_message.equals(JAPModel.CHANGED_ALLOW_UPDATE_DIRECT_CONNECTION)) {
                this.m_comboAnonymousConnection.setSelectedIndex(JAPModel.getInstance().getUpdateAnonymousConnectionSetting());
            } else if (a_message.equals(JAPModel.CHANGED_NOTIFY_JAP_UPDATES)) {
                this.m_cbxRemindOptionalUpdate.setSelected(JAPModel.getInstance().isReminderForOptionalUpdateActivated());
            } else if (a_message.equals(JAPModel.CHANGED_NOTIFY_JAVA_UPDATES)) {
                this.m_cbxRemindJavaUpdate.setSelected(JAPModel.getInstance().isReminderForJavaUpdateActivated());
            }
        }
    }

    protected boolean onOkPressed() {
        JAPModel.getInstance().setUpdateAnonymousConnectionSetting(this.m_comboAnonymousConnection.getSelectedIndex());
        JAPModel.getInstance().setReminderForOptionalUpdate(this.m_cbxRemindOptionalUpdate.isSelected());
        JAPModel.getInstance().setReminderForJavaUpdate(this.m_cbxRemindJavaUpdate.isSelected());
        return true;
    }

    public void onResetToDefaultsPressed() {
        this.m_comboAnonymousConnection.setSelectedIndex(0);
        this.m_cbxRemindOptionalUpdate.setSelected(true);
        this.m_cbxRemindJavaUpdate.setSelected(!JAPController.getInstance().isPortableMode());
    }

    protected void onUpdateValues() {
        this.m_comboAnonymousConnection.setSelectedIndex(JAPModel.getInstance().getUpdateAnonymousConnectionSetting());
        this.m_cbxRemindOptionalUpdate.setSelected(JAPModel.getInstance().isReminderForOptionalUpdateActivated());
        this.m_cbxRemindJavaUpdate.setSelected(JAPModel.getInstance().isReminderForJavaUpdateActivated());
    }

    public void run() {
        this.updateVersionInfo(true);
    }

    public void updateVersionInfo(boolean a_bFetchUpdateFromIS) {
        if (a_bFetchUpdateFromIS) {
            this.m_taInfo.setText(JAPMessages.getString("updateFetchVersionInfo"));
            this.m_releaseVersion = InfoServiceHolder.getInstance().getJAPVersionInfo(1);
            this.m_devVersion = InfoServiceHolder.getInstance().getJAPVersionInfo(2);
        } else {
            JAPVersionInfo devVersion = (JAPVersionInfo)Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = JAPConfUpdate.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).getEntryById("/japDevelopment.jnlp");
            JAPVersionInfo releaseVersion = (JAPVersionInfo)Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = JAPConfUpdate.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).getEntryById("/japRelease.jnlp");
            if (devVersion != null && releaseVersion != null) {
                this.m_releaseVersion = releaseVersion;
                this.m_devVersion = devVersion;
            } else {
                return;
            }
        }
        if (this.m_releaseVersion == null || this.m_devVersion == null) {
            this.m_taInfo.setText(JAPMessages.getString("updateFetchVersionInfoFailed"));
        } else {
            Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = JAPConfUpdate.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).update(this.m_releaseVersion);
            Database.getInstance(class$anon$infoservice$JAPVersionInfo == null ? (class$anon$infoservice$JAPVersionInfo = JAPConfUpdate.class$("anon.infoservice.JAPVersionInfo")) : class$anon$infoservice$JAPVersionInfo).update(this.m_devVersion);
            this.m_comboType.setEnabled(true);
            String text = "";
            JAPVersionInfo info = this.m_devVersion;
            if ("00.20.010".compareTo(info.getJapVersion()) >= 0) {
                text = JAPMessages.getString("japUpdate_YouHaveAlreadyTheNewestVersion");
            } else {
                text = JAPMessages.getString("japUpdate_NewVersionAvailable");
                if (!info.isJavaVersionStillSupported()) {
                    text = text + "\n" + JAPMessages.getString(JAPUpdateWizard.MSG_JAVA_TOO_OLD, new Object[]{JavaVersionDBEntry.CURRENT_JAVA_VERSION, info.getSupportedJavaVersion()});
                }
            }
            this.m_taInfo.setText(text);
            this.m_taInfoScrollPane.getHorizontalScrollBar().setValue(0);
            this.m_labelVersion.setText(this.m_releaseVersion.getJapVersion());
            if (this.m_releaseVersion.getDate() != null) {
                this.m_labelDate.setText(this.m_DateFormat.format(this.m_releaseVersion.getDate()));
            } else {
                this.m_labelDate.setText(JAPMessages.getString("updateUnknown"));
            }
            this.m_bttnUpgrade.setEnabled(true);
            this.m_comboType.setSelectedIndex(1);
            this.itemStateChanged(new ItemEvent(this.m_comboType, 0, this.m_comboType, 1));
        }
        this.m_bttnCheckForUpgrade.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(COMMAND_UPGRADE)) {
            if (!AbstractOS.getInstance().isJavaWebstart()) {
                try {
                    this.m_threadGetVersionInfo.join();
                }
                catch (NullPointerException ex) {
                }
                catch (Exception ex) {
                    LogHolder.log(2, LogType.MISC, ex);
                }
                if (this.m_comboType.getSelectedIndex() == 0) {
                    SoftwareUpdater.show(this.m_releaseVersion, this.getRootPanel());
                } else {
                    SoftwareUpdater.show(this.m_devVersion, this.getRootPanel());
                }
            } else {
                JAPDialog.showMessageDialog(JAPController.getInstance().getCurrentView(), JAPMessages.getString("webstartUpdateButton"), JAPMessages.getString("newVersionAvailableTitle"));
            }
        } else if (e.getActionCommand().equals(COMMAND_CHECKFORUPGRADE)) {
            this.m_bttnCheckForUpgrade.setEnabled(false);
            this.m_threadGetVersionInfo = new Thread(this);
            this.m_threadGetVersionInfo.start();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (this.m_comboType.getSelectedIndex() == 0) {
                this.m_labelVersion.setText(this.m_releaseVersion.getJapVersion());
                if (this.m_releaseVersion.getDate() != null) {
                    this.m_labelDate.setText(this.m_DateFormat.format(this.m_releaseVersion.getDate()));
                } else {
                    this.m_labelDate.setText(JAPMessages.getString("updateUnknown"));
                }
            } else {
                this.m_labelVersion.setText(this.m_devVersion.getJapVersion());
                if (this.m_devVersion.getDate() != null) {
                    this.m_labelDate.setText(this.m_DateFormat.format(this.m_devVersion.getDate()));
                } else {
                    this.m_labelDate.setText(JAPMessages.getString("updateUnknown"));
                }
            }
        }
    }

    public String getTabTitle() {
        return JAPMessages.getString("ngUpdatePanelTitle");
    }

    public String getHelpContext() {
        return "update";
    }

    protected void onRootPanelShown() {
        this.updateVersionInfo(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JAPConfUpdate.this.m_taInfoScrollPane.getHorizontalScrollBar().setValue(0);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

