/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.client.TrustModel;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.util.ClassUtil;
import anon.util.JAPMessages;
import anon.util.ResourceLoader;
import anon.util.Util;
import gui.JAPHelpContext;
import gui.dialog.JAPDialog;
import gui.help.JAPHelp;
import jap.JAPController;
import jap.JAPModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import logging.LogHolder;
import logging.LogType;

public class MacOSXLib {
    public static final String JAP_MACOSX_LIB_REQUIRED_VERSION = "00.00.005";
    public static final String JAP_MACOSX_LIB = "MacOSX";
    public static final String JAP_MACOSX_LIB_FILENAME = "libMacOSX.jnilib";
    private static final String JAP_MACOSX_LIB_OLD_FILENAME = "libMacOSX.jnilib.old";
    public static final String JAP_MACOSX_LIB_REQUIRED_VERSION_FILENAME = "libMacOSX.jnilib.00.00.005";
    private static final String MSG_MACOSX_LIB_UPDATE = (class$jap$MacOSXLib == null ? (class$jap$MacOSXLib = MacOSXLib.class$("jap.MacOSXLib")) : class$jap$MacOSXLib).getName() + "_macOSXLibUpdate";
    private static final String UPDATE_PATH;
    private static final String MSG_SETTINGS;
    private static final String MSG_ANONYMITY_MODE;
    private static final String MSG_SHOW_DETAILS;
    private static boolean ms_bLibraryLoaded;
    static /* synthetic */ Class class$jap$MacOSXLib;
    static /* synthetic */ Class class$jap$SystrayPopupMenu;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;

    private MacOSXLib() {
    }

    public static void dockMenuCallback(String a_command) {
        final String cmd = a_command;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (cmd.equals(MSG_ANONYMITY_MODE)) {
                    if (JAPController.getInstance().getAnonMode()) {
                        JAPController.getInstance().stop();
                    } else {
                        JAPController.getInstance().start();
                    }
                } else if (cmd.equals(MSG_SHOW_DETAILS)) {
                    JAPController.getInstance().showConfigDialog("ANON_TAB", JAPController.getInstance().getCurrentMixCascade());
                } else if (cmd.equals(MSG_SETTINGS)) {
                    JAPController.getInstance().showConfigDialog();
                } else if (cmd.equals(JAPHelp.MSG_HELP_MENU_ITEM)) {
                    JAPHelp help = JAPHelp.getInstance();
                    help.setContext(JAPHelpContext.createHelpContext("index", JAPController.getInstance().getViewWindow()));
                    help.loadCurrentContext();
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(cmd, ",");
                    if (tokenizer.countTokens() == 2) {
                        long model = Long.parseLong(tokenizer.nextToken());
                        TrustModel.setCurrentTrustModel(model);
                        MixCascade cascade = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = MacOSXLib.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(tokenizer.nextToken());
                        if (cascade != null) {
                            JAPController.getInstance().setCurrentMixCascade(cascade);
                        }
                    }
                }
            }
        });
    }

    public static void init() {
        if (MacOSXLib.getUpdatePath() != null && JAPModel.getInstance().isMacOSXLibraryUpdateAtStartupNeeded()) {
            MacOSXLib.update();
        }
        MacOSXLib.load();
        MacOSXLib.checkLibVersion();
        if (ms_bLibraryLoaded) {
            MacOSXLib.nativeInit();
            MacOSXLib.nativeInitDockMenu();
        }
    }

    private static void load() {
        try {
            System.loadLibrary(JAP_MACOSX_LIB);
            ms_bLibraryLoaded = true;
        }
        catch (Throwable t) {
            LogHolder.log(2, LogType.GUI, "Could not initialise MacOSXLib", t);
            ms_bLibraryLoaded = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkLibVersion() {
        boolean bUpdateNeeded = false;
        String version = null;
        if (ms_bLibraryLoaded) {
            try {
                version = MacOSXLib.getLibVersion();
                LogHolder.log(6, LogType.GUI, "Existing libMacOSX.jnilib version: " + version);
            }
            catch (Throwable t) {
                LogHolder.log(6, LogType.GUI, "libMacOSX.jnilib does not support version check. Update needed.");
                bUpdateNeeded = true;
            }
        } else {
            LogHolder.log(6, LogType.GUI, "libMacOSX.jnilib does not exist or failed to load. Update needed.");
            bUpdateNeeded = true;
        }
        LogHolder.log(6, LogType.GUI, "Required libMacOSX.jnilib version: 00.00.005");
        if (version != null && version.compareTo(JAP_MACOSX_LIB_REQUIRED_VERSION) < 0) {
            bUpdateNeeded = true;
        }
        if (bUpdateNeeded && JAPModel.getInstance().isMacOSXLibraryUpdateAtStartupNeeded()) {
            LogHolder.log(6, LogType.GUI, "Update failed twice. Giving up.");
            JAPModel.getInstance().setMacOSXLibraryUpdateAtStartupNeeded(false);
            JAPController.getInstance().saveConfigFile();
            return;
        }
        if (bUpdateNeeded) {
            LogHolder.log(6, LogType.GUI, "Trying to fetch libMacOSX.jnilib.00.00.005 from JAP.jar.");
            if (ResourceLoader.getResourceURL(JAP_MACOSX_LIB_REQUIRED_VERSION_FILENAME) != null && MacOSXLib.getUpdatePath() != null) {
                if (MacOSXLib.update()) {
                    JAPModel.getInstance().setMacOSXLibraryUpdateAtStartupNeeded(false);
                    JAPController.getInstance().saveConfigFile();
                    MacOSXLib.load();
                    try {
                        version = MacOSXLib.getLibVersion();
                    }
                    catch (Throwable t) {
                        version = null;
                    }
                    if (version != null && version.compareTo(JAP_MACOSX_LIB_REQUIRED_VERSION) >= 0) {
                        LogHolder.log(6, LogType.GUI, "libMacOSX.jnilib successfully updated to version 00.00.005.");
                        return;
                    }
                    LogHolder.log(6, LogType.GUI, "libMacOSX.jnilib successfully updated to version 00.00.005. Restart needed.");
                    MacOSXLib.informUserAboutJapRestart();
                }
                LogHolder.log(6, LogType.GUI, "Update failed, trying to restart JAP to retry update.");
                JAPModel.getInstance().setMacOSXLibraryUpdateAtStartupNeeded(true);
                JAPController.getInstance().saveConfigFile();
                MacOSXLib.informUserAboutJapRestart();
                return;
            }
            LogHolder.log(6, LogType.GUI, "Required version not available in JAP.jar. Update aborted.");
            return;
        }
        if (!JAPModel.getInstance().isMacOSXLibraryUpdateAtStartupNeeded()) return;
        JAPModel.getInstance().setMacOSXLibraryUpdateAtStartupNeeded(false);
        JAPController.getInstance().saveConfigFile();
    }

    private static boolean update() {
        LogHolder.log(6, LogType.GUI, "Trying to update libMacOSX.jnilib to version 00.00.005.");
        if (MacOSXLib.renameLib(JAP_MACOSX_LIB_FILENAME, JAP_MACOSX_LIB_OLD_FILENAME) && MacOSXLib.extractDLL(new File(MacOSXLib.getLibFileName()))) {
            JAPModel.getInstance().setMacOSXLibraryUpdateAtStartupNeeded(false);
            JAPController.getInstance().saveConfigFile();
            return true;
        }
        MacOSXLib.renameLib(JAP_MACOSX_LIB_OLD_FILENAME, JAP_MACOSX_LIB_FILENAME);
        return false;
    }

    private static String getUpdatePath() {
        String file = MacOSXLib.getLibFileName();
        if (file != null) {
            file = new File(file).getParent();
        }
        return file;
    }

    public static String getLibFileName() {
        if (UPDATE_PATH != null) {
            if (!UPDATE_PATH.endsWith(File.separator)) {
                return UPDATE_PATH + File.separator + JAP_MACOSX_LIB_FILENAME;
            }
            return UPDATE_PATH + JAP_MACOSX_LIB_FILENAME;
        }
        return null;
    }

    private static boolean renameLib(String a_oldName, String a_newName) {
        try {
            File file = new File(MacOSXLib.getUpdatePath() + File.separator + a_oldName);
            if (file.exists()) {
                file.renameTo(new File(MacOSXLib.getUpdatePath() + File.separator + a_newName));
                return true;
            }
            return true;
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.GUI, "Unable to copy " + MacOSXLib.getUpdatePath() + File.separator + a_oldName + ".", e);
            return false;
        }
    }

    private static boolean extractDLL(File a_file) {
        boolean bSuccess = false;
        InputStream streamOne = null;
        FileOutputStream streamTwo = null;
        LogHolder.log(7, LogType.GUI, "Extracting libMacOSX.jnilib.00.00.005 from jar-file to: " + a_file);
        try {
            streamOne = ResourceLoader.loadResourceAsStream(JAP_MACOSX_LIB_REQUIRED_VERSION_FILENAME);
            streamTwo = new FileOutputStream(a_file);
            Util.copyStream(streamOne, streamTwo);
            return true;
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.MISC, e);
            Util.closeStream(streamOne);
            Util.closeStream(streamTwo);
            return bSuccess;
        }
    }

    private static void informUserAboutJapRestart() {
        JAPDialog.showMessageDialog(JAPController.getInstance().getCurrentView(), JAPMessages.getString(MSG_MACOSX_LIB_UPDATE));
        JAPController.goodBye(false);
    }

    public static JMenu showDockMenu() {
        JMenu menu = new JMenu();
        JCheckBoxMenuItem chk = new JCheckBoxMenuItem(JAPMessages.getString(MSG_ANONYMITY_MODE));
        chk.setSelected(JAPController.getInstance().getAnonMode());
        chk.setActionCommand(MSG_ANONYMITY_MODE);
        menu.add(chk);
        JMenuItem item = new JMenuItem(JAPMessages.getString(MSG_SHOW_DETAILS));
        item.setActionCommand(MSG_SHOW_DETAILS);
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem(JAPMessages.getString(MSG_SETTINGS));
        item.setActionCommand(MSG_SETTINGS);
        menu.add(item);
        item = new JMenuItem(JAPMessages.getString(JAPHelp.MSG_HELP_MENU_ITEM));
        item.setActionCommand(JAPHelp.MSG_HELP_MENU_ITEM);
        menu.add(item);
        menu.add(new JSeparator());
        Vector vec = TrustModel.getTrustModels();
        for (int i = 0; i < vec.size(); ++i) {
            TrustModel model = (TrustModel)vec.elementAt(i);
            if (!model.isAdded()) continue;
            JMenu sub = model == TrustModel.getCurrentTrustModel() ? new JMenu(model.getName() + " (" + JAPMessages.getString("active") + ")") : new JMenu(model.getName());
            Vector cascades = Database.getInstance(class$anon$infoservice$MixCascade == null ? MacOSXLib.class$("anon.infoservice.MixCascade") : class$anon$infoservice$MixCascade).getEntryList();
            for (int j = 0; j < cascades.size(); ++j) {
                MixCascade cascade = (MixCascade)cascades.elementAt(j);
                if (!model.isTrusted(cascade)) continue;
                item = new JMenuItem(cascade.getName());
                if (JAPController.getInstance().getCurrentMixCascade() == cascade) {
                    item.setSelected(true);
                }
                item.setActionCommand(model.getId() + "," + cascade.getId());
                sub.add(item);
            }
            menu.add(sub);
        }
        return menu;
    }

    private static native void nativeInit();

    private static native void nativeInitDockMenu();

    private static native String getLibVersion();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MSG_SETTINGS = (class$jap$SystrayPopupMenu == null ? (class$jap$SystrayPopupMenu = MacOSXLib.class$("jap.SystrayPopupMenu")) : class$jap$SystrayPopupMenu).getName() + "_settings";
        MSG_ANONYMITY_MODE = (class$jap$SystrayPopupMenu == null ? (class$jap$SystrayPopupMenu = MacOSXLib.class$("jap.SystrayPopupMenu")) : class$jap$SystrayPopupMenu).getName() + "_anonymityMode";
        MSG_SHOW_DETAILS = (class$jap$SystrayPopupMenu == null ? (class$jap$SystrayPopupMenu = MacOSXLib.class$("jap.SystrayPopupMenu")) : class$jap$SystrayPopupMenu).getName() + "_showDetails";
        ms_bLibraryLoaded = false;
        File japdir = ClassUtil.getClassDirectory(class$jap$MacOSXLib == null ? (class$jap$MacOSXLib = MacOSXLib.class$("jap.MacOSXLib")) : class$jap$MacOSXLib);
        if (japdir == null) {
            String strUpdatePath = null;
            try {
                strUpdatePath = System.getProperty("user.dir", null);
            }
            catch (Throwable a_e) {
                a_e.printStackTrace();
            }
            UPDATE_PATH = strUpdatePath;
        } else {
            UPDATE_PATH = japdir.getParent();
        }
    }
}

