/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.forward.server.ForwardServerManager;
import anon.forward.server.SkypeServerManager;
import anon.transport.address.AddressMappingException;
import anon.transport.address.Endpoint;
import anon.transport.address.IAddress;
import anon.transport.address.MalformedURNException;
import anon.transport.address.SkypeAddress;
import anon.util.JAPMessages;
import jap.forward.JAPRoutingMessage;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class JAPRoutingForwardingModeSelector
extends Observable {
    public static final int FORWARDING_MODE_UNKNOW = -1;
    public static final String FORWARDING_MODE_NAME_UNKNOW = "unknow";
    public static final int FORWARDING_MODE_TCP = 0;
    public static final String FORWARDING_MODE_NAME_TCP = "tcpip";
    public static final int FORWARDING_MODE_SKYPE = 1;
    public static final String FORWARDING_MODE_NAME_SKYPE = "skype";
    public static final int FORWARDING_MODE_LOCAL = 2;
    public static final String FORWARDING_MODE_NAME_LOCAL = "local";
    private static final String DEFAULT_SKYPE_FORWARDER_ADDRESS = "japforwarder";
    private static final String ALTERNATIVE_SKYPE_FORWARDER_ADDRESS = "jondosforwarder";
    private static final String DEFAULT_SKYPE_APP_NAME = "jap";
    private static String m_skypeForwarderAddress;
    private static String m_skypeApplicationName;
    private static int m_serverPort;
    private Hashtable m_forwardingModes;
    private int m_currentForwardingMode = 0;

    private static String buildSkypeURN(String a_address, String a_applicationName) {
        return "urn:endpoint:skype:user(" + a_address + "):application(" + a_applicationName + ")";
    }

    public JAPRoutingForwardingModeSelector() {
        m_serverPort = (int)Math.round(Math.abs(Math.random() * 64511.0)) + 1025;
        m_skypeForwarderAddress = DEFAULT_SKYPE_FORWARDER_ADDRESS;
        m_skypeApplicationName = DEFAULT_SKYPE_APP_NAME;
        this.m_forwardingModes = new Hashtable();
        this.m_forwardingModes.put(new Integer(0), new TransportMode(0, FORWARDING_MODE_NAME_TCP, "settingsRoutingForwardingModeTCPIP", null));
        try {
            TransportMode mode = new TransportMode(1, FORWARDING_MODE_NAME_SKYPE, "settingsRoutingForwardingModeskype", new SkypeAddress(JAPRoutingForwardingModeSelector.getSkypeEndPoint(m_skypeForwarderAddress)));
            mode.addAddress(new SkypeAddress(JAPRoutingForwardingModeSelector.getSkypeEndPoint(ALTERNATIVE_SKYPE_FORWARDER_ADDRESS)));
            this.m_forwardingModes.put(new Integer(1), mode);
        }
        catch (AddressMappingException addressMappingException) {
            // empty catch block
        }
        this.m_forwardingModes.put(new Integer(2), new TransportMode(2, FORWARDING_MODE_NAME_LOCAL, "settingsRoutingForwardingModelocal", null));
    }

    public String getDefaultSkypeForwarderAddress() {
        return DEFAULT_SKYPE_FORWARDER_ADDRESS;
    }

    public String getSkypeForwarderAddress() {
        return m_skypeForwarderAddress;
    }

    public void setSkypeForwarderAddress(String a_newAddress) {
        LogHolder.log(7, LogType.GUI, "We set the forwarder address to " + a_newAddress);
        m_skypeForwarderAddress = a_newAddress;
        try {
            TransportMode t = (TransportMode)this.m_forwardingModes.get(new Integer(1));
            t.setAddress(new SkypeAddress(JAPRoutingForwardingModeSelector.getSkypeEndPoint(a_newAddress)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getSkypeApplicationName() {
        return m_skypeApplicationName;
    }

    public void setSkypeApplicationName(String a_newName) {
        m_skypeApplicationName = a_newName;
    }

    private static String getCurrentSkypeURN(String a_skypeForwarderAddress) {
        return JAPRoutingForwardingModeSelector.buildSkypeURN(a_skypeForwarderAddress, m_skypeApplicationName);
    }

    private static Endpoint getSkypeEndPoint(String a_skypeForwarderAddress) {
        Endpoint result = null;
        try {
            result = new Endpoint(JAPRoutingForwardingModeSelector.getCurrentSkypeURN(a_skypeForwarderAddress));
        }
        catch (MalformedURNException e) {
            e.printStackTrace();
        }
        return result;
    }

    public TransportMode getCurrentForwardingMode() {
        TransportMode returnValue = null;
        returnValue = (TransportMode)this.m_forwardingModes.get(new Integer(this.m_currentForwardingMode));
        return returnValue;
    }

    public IAddress getUserProvidetForwarder() {
        return this.getCurrentForwardingMode().getAddress();
    }

    public boolean setCurrentForwardingMode(TransportMode a_transportMode) {
        if (a_transportMode == null) {
            return false;
        }
        Enumeration enumModes = this.m_forwardingModes.keys();
        while (enumModes.hasMoreElements()) {
            Integer key = (Integer)enumModes.nextElement();
            if (a_transportMode != this.m_forwardingModes.get(key)) continue;
            return this.setCurrentForwardingMode(key);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentForwardingMode(int a_newTransport) {
        LogHolder.log(7, LogType.GUI, "We set the forwarding mode to " + a_newTransport);
        if (a_newTransport == -1) {
            return false;
        }
        if (a_newTransport >= this.m_forwardingModes.size()) {
            return false;
        }
        if (a_newTransport == this.m_currentForwardingMode) {
            return false;
        }
        Hashtable hashtable = this.m_forwardingModes;
        synchronized (hashtable) {
            this.m_currentForwardingMode = a_newTransport;
            this.setChanged();
            this.notifyObservers(new JAPRoutingMessage(17));
        }
        return true;
    }

    public static int getServerPort() {
        return m_serverPort;
    }

    public void setServerPort(int a_newPort) {
        m_serverPort = a_newPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getForwardingModes() {
        Vector returnValue = new Vector();
        Hashtable hashtable = this.m_forwardingModes;
        synchronized (hashtable) {
            Enumeration forwardingModes = this.m_forwardingModes.elements();
            while (forwardingModes.hasMoreElements()) {
                returnValue.addElement(forwardingModes.nextElement());
            }
        }
        Collections.sort(returnValue);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdFromIdentifier(String a_identifier) {
        Hashtable hashtable = this.m_forwardingModes;
        synchronized (hashtable) {
            Enumeration forwardingModes = this.m_forwardingModes.elements();
            while (forwardingModes.hasMoreElements()) {
                TransportMode modeToTest = (TransportMode)forwardingModes.nextElement();
                if (!a_identifier.equals(modeToTest.getName())) continue;
                return modeToTest.getIdentifier();
            }
        }
        return -1;
    }

    public static final class TransportMode
    implements Comparable {
        private int m_identifier;
        private String m_forwardModeName;
        private Vector m_forwadingAddress = new Vector();
        private int m_iCurrentForwardingAddress = 0;
        private String m_name;
        public static final TransportMode UNKNOWN = new TransportMode(-1, "unknow", "", null);

        public TransportMode(int a_forwardModeIdentifier, String a_name, String a_forwardGUIModeName, IAddress a_forwardingAddress) {
            this.m_forwadingAddress.addElement(a_forwardingAddress);
            this.m_identifier = a_forwardModeIdentifier;
            this.m_forwardModeName = a_forwardGUIModeName;
            this.m_name = a_name;
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof TransportMode)) {
                return 0;
            }
            if (this.getIdentifier() > ((TransportMode)o).getIdentifier()) {
                return 1;
            }
            return -1;
        }

        public int getIdentifier() {
            return this.m_identifier;
        }

        public String toString() {
            return JAPMessages.getString(this.m_forwardModeName);
        }

        public Object startServer(String a_appName) {
            return ForwardServerManager.getInstance().addServerManager(new SkypeServerManager(a_appName));
        }

        public Object startServer() {
            if (this.getIdentifier() == 1) {
                return this.startServer(JAPRoutingForwardingModeSelector.getSkypeApplicationName());
            }
            if (this.getIdentifier() == 0) {
                return ForwardServerManager.getInstance().addListenSocket(JAPRoutingForwardingModeSelector.getServerPort());
            }
            return null;
        }

        public String getName() {
            return this.m_name;
        }

        public IAddress getAddress() {
            if (this.m_forwadingAddress.size() == 0) {
                return null;
            }
            return (IAddress)this.m_forwadingAddress.elementAt(this.m_iCurrentForwardingAddress);
        }

        public IAddress nextAddress() {
            if (this.m_forwadingAddress.size() == 0) {
                return null;
            }
            if (this.m_iCurrentForwardingAddress == this.m_forwadingAddress.size() - 1) {
                this.m_iCurrentForwardingAddress = -1;
            }
            ++this.m_iCurrentForwardingAddress;
            return this.getAddress();
        }

        public void setAddress(IAddress a_newAddress) {
            this.m_forwadingAddress = new Vector();
            this.m_forwadingAddress.addElement(a_newAddress);
            try {
                this.addAddress(new SkypeAddress(JAPRoutingForwardingModeSelector.getSkypeEndPoint(JAPRoutingForwardingModeSelector.DEFAULT_SKYPE_FORWARDER_ADDRESS)));
                this.addAddress(new SkypeAddress(JAPRoutingForwardingModeSelector.getSkypeEndPoint(JAPRoutingForwardingModeSelector.ALTERNATIVE_SKYPE_FORWARDER_ADDRESS)));
            }
            catch (AddressMappingException addressMappingException) {
                // empty catch block
            }
        }

        private void addAddress(IAddress a_newAddress) {
            if (this.m_forwadingAddress.indexOf(a_newAddress) < 0) {
                this.m_forwadingAddress.addElement(a_newAddress);
            }
        }

        public boolean isLocal() {
            return this.getIdentifier() == 2;
        }

        public boolean isSkype() {
            return this.getIdentifier() == 1;
        }
    }
}

