/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.AnonServerDescription;
import anon.error.AnonServiceException;
import anon.pay.PayAccount;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLEasyCC;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLErrorMessage
extends AnonServiceException
implements IXMLEncodable {
    public static final int ERR_OK = 0;
    public static final int ERR_INTERNAL_SERVER_ERROR = 1;
    public static final int ERR_WRONG_FORMAT = 2;
    public static final int ERR_WRONG_DATA = 3;
    public static final int ERR_KEY_NOT_FOUND = 4;
    public static final int ERR_BAD_SIGNATURE = 5;
    public static final int ERR_BAD_REQUEST = 6;
    public static final int ERR_NO_ACCOUNTCERT = 7;
    public static final int ERR_NO_BALANCE = 8;
    public static final int ERR_NO_CONFIRMATION = 9;
    public static final int ERR_ACCOUNT_EMPTY = 10;
    public static final int ERR_CASCADE_LENGTH = 11;
    public static final int ERR_DATABASE_ERROR = 12;
    public static final int ERR_INSUFFICIENT_BALANCE = 13;
    public static final int ERR_NO_FLATRATE_OFFERED = 14;
    public static final int ERR_INVALID_CODE = 15;
    public static final int ERR_OUTDATED_CC = 16;
    public static final int ERR_INVALID_PRICE_CERTS = 17;
    public static final int ERR_MULTIPLE_LOGIN = 18;
    public static final int ERR_NO_RECORD_FOUND = 19;
    public static final int ERR_SUCCESS_BUT_WITH_ERRORS = 20;
    public static final int ERR_BLOCKED = 21;
    public static final int ERR_NOT_SYNCHRONIZED = 22;
    private int m_iErrorCode;
    private IXMLEncodable m_oMessageObject;
    private PayAccount m_account;
    private static final String[] m_errStrings = new String[]{"Success", "Internal Server Error", "Wrong format", "Wrong Data", "Key not found", "Bad Signature", "Bad request", "No account certificate", "No balance", "No cost confirmation", "Account is empty", "Cascade too long", "Database error", "Insufficient balance", "No flatrate offered", "Invalid code", "outdated CC", "Invalid price certificates", "multiple login is not allowed", "no record found", "operation succeeded, but there were errors", "this account is blocked", "your clock in not synchronized"};
    public static final String XML_ELEMENT_NAME = "ErrorMessage";

    public XMLErrorMessage(Document doc, PayAccount a_account, AnonServerDescription a_service) throws Exception {
        super(a_service, XMLErrorMessage.getMessage(Integer.parseInt(doc.getDocumentElement().getAttribute("code")), XMLUtil.parseValue((Node)doc.getDocumentElement(), "")));
        this.setValues(doc.getDocumentElement(), a_account);
    }

    public XMLErrorMessage(Element element, PayAccount a_account, AnonServerDescription a_service) throws Exception {
        super(a_service, XMLErrorMessage.getMessage(Integer.parseInt(element.getAttribute("code")), XMLUtil.parseValue((Node)element, "")));
        this.setValues(element, a_account);
    }

    public XMLErrorMessage(int errorCode, String message) {
        this(errorCode, message, null, null);
    }

    public XMLErrorMessage(int errorCode) {
        this(errorCode, (PayAccount)null, (AnonServerDescription)null);
    }

    public XMLErrorMessage(int errorCode, PayAccount a_account) {
        this(errorCode, a_account, (AnonServerDescription)null);
    }

    public XMLErrorMessage(int errorCode, String message, PayAccount a_account, AnonServerDescription a_service) {
        super(a_service, XMLErrorMessage.getMessage(errorCode, message));
        this.m_iErrorCode = errorCode;
        this.m_account = a_account;
    }

    public XMLErrorMessage(int errorCode, String message, IXMLEncodable messageObject, PayAccount a_account, AnonServerDescription a_service) {
        super(a_service, XMLErrorMessage.getMessage(errorCode, message));
        this.m_iErrorCode = errorCode;
        this.m_oMessageObject = messageObject;
        this.m_account = a_account;
    }

    public XMLErrorMessage(int errorCode, AnonServerDescription a_service) {
        this(errorCode, null, null, a_service);
    }

    public XMLErrorMessage(int errorCode, PayAccount a_account, AnonServerDescription a_service) {
        this(errorCode, null, a_account, a_service);
    }

    private static String getMessage(int errorCode, String a_message) {
        if (a_message != null) {
            return a_message;
        }
        if (errorCode < 0 || errorCode > m_errStrings.length) {
            return "Unknown message";
        }
        return m_errStrings[errorCode];
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
        elemRoot.setAttribute("code", Integer.toString(this.m_iErrorCode));
        XMLUtil.setValue((Node)elemRoot, this.getMessage());
        if (this.m_oMessageObject != null) {
            Element elemObjectRoot = a_doc.createElement("MessageObject");
            Element elemObject = this.m_oMessageObject.toXmlElement(a_doc);
            elemObjectRoot.appendChild(elemObject);
            elemRoot.appendChild(elemObjectRoot);
        }
        return elemRoot;
    }

    public long getAccountNumber() {
        if (this.m_account == null) {
            return 0L;
        }
        return this.m_account.getAccountNumber();
    }

    public PayAccount getAccount() {
        return this.m_account;
    }

    public String getPIID() {
        if (this.m_account == null) {
            return null;
        }
        return this.m_account.getPIID();
    }

    public int getXmlErrorCode() {
        return this.m_iErrorCode;
    }

    public IXMLEncodable getMessageObject() {
        return this.m_oMessageObject;
    }

    public void setMessageObject(IXMLEncodable a_messageObject) {
        this.m_oMessageObject = a_messageObject;
    }

    private void setValues(Element elemRoot, PayAccount a_account) throws Exception {
        if (!elemRoot.getTagName().equals(XML_ELEMENT_NAME)) {
            throw new Exception("Format error: Root element wrong tagname");
        }
        this.m_iErrorCode = Integer.parseInt(elemRoot.getAttribute("code"));
        this.m_account = a_account;
        try {
            Node objectRoot = XMLUtil.getFirstChildByName(elemRoot, "MessageObject");
            if (objectRoot == null) {
                return;
            }
            Node nodeFound = XMLUtil.getFirstChildByName(objectRoot, "AccountInfo");
            if (nodeFound != null && nodeFound instanceof Element) {
                this.m_oMessageObject = new XMLAccountInfo((Element)nodeFound);
            }
            if ((nodeFound = XMLUtil.getFirstChildByName(objectRoot, "CC")) != null && nodeFound instanceof Element) {
                this.m_oMessageObject = new XMLEasyCC((Element)nodeFound);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

