/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.JAPJIntField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class IPTextField
extends JPanel
implements FocusListener {
    private JTextField[] iptext;
    private Vector<FocusListener> m_focusListeners;

    public IPTextField() {
        super.addFocusListener(this);
        this.initIPTextField("");
        for (int i = 0; i < this.iptext.length; ++i) {
            this.iptext[i].addFocusListener(this);
        }
    }

    private void initIPTextField(String IPStr) {
        ActionListener nextfocusaction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((Component)evt.getSource()).transferFocus();
            }
        };
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.iptext = new JTextField[4];
        GridBagConstraints ic = new GridBagConstraints();
        ic.anchor = 17;
        ic.fill = 2;
        ic.insets = new Insets(1, 1, 1, 1);
        ic.gridx = 0;
        ic.gridy = 0;
        int pos = 0;
        for (int i = 0; i < 4; ++i) {
            String str;
            int npos = IPStr.indexOf(46, pos);
            if (npos < 0) {
                str = "";
            } else {
                str = IPStr.substring(pos, npos - 1);
                pos = npos + 1;
            }
            if (i > 0) {
                JLabel punkt = new JLabel(".");
                ic.weightx = 0.0;
                layout.setConstraints(punkt, ic);
                this.add(punkt);
                ++ic.gridx;
            }
            this.iptext[i] = new JAPJIntField(255, true);
            this.iptext[i].setMinimumSize(this.iptext[i].getPreferredSize());
            this.iptext[i].setText(str);
            ic.weightx = 1.0;
            layout.setConstraints(this.iptext[i], ic);
            this.add(this.iptext[i]);
            this.iptext[i].addActionListener(nextfocusaction);
            ++ic.gridx;
        }
    }

    @Override
    public void addFocusListener(FocusListener a_fl) {
        if (this.m_focusListeners == null) {
            this.m_focusListeners = new Vector();
        }
        if (a_fl != null && !this.m_focusListeners.contains(a_fl)) {
            this.m_focusListeners.addElement(a_fl);
        }
    }

    @Override
    public void removeFocusListener(FocusListener a_listener) {
        if (this.m_focusListeners != null) {
            this.m_focusListeners.removeElement(a_listener);
        }
    }

    public String getText() {
        String str = "";
        for (int i = 0; i < 4; ++i) {
            str = this.iptext[i].getText().length() == 0 ? str + "0" : str + this.iptext[i].getText();
            if (i >= 3) continue;
            str = str + ".";
        }
        return str;
    }

    public void setText(String str) {
        try {
            str.length();
            InetAddress ip = InetAddress.getByName(str);
            byte[] b = ip.getAddress();
            for (int i = 0; i < 4; ++i) {
                if (b[i] >= 0) {
                    this.iptext[i].setText(Byte.toString(b[i]));
                    continue;
                }
                this.iptext[i].setText(Integer.toString(b[i] + 256));
            }
            return;
        }
        catch (UnknownHostException ex) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        for (int i = 0; i < 4; ++i) {
            this.iptext[i].setText("");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.iptext.length; ++i) {
            if (this.iptext[i] == null) continue;
            this.iptext[i].setEnabled(enabled);
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < 4; ++i) {
            if (this.iptext[i].getText().length() == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isCorrect() {
        for (int i = 0; i < 4; ++i) {
            if (this.iptext[i].getText().length() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void focusGained(FocusEvent event) {
        Enumeration<FocusListener> listeners = this.m_focusListeners.elements();
        event = new FocusEvent(this, event.getID());
        while (listeners.hasMoreElements()) {
            listeners.nextElement().focusGained(event);
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.isCorrect() || this.isEmpty()) {
            Enumeration<FocusListener> listeners = this.m_focusListeners.elements();
            event = new FocusEvent(this, event.getID());
            while (listeners.hasMoreElements()) {
                listeners.nextElement().focusLost(event);
            }
        }
    }
}

