/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.util.ClassUtil;
import anon.util.JAPMessages;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public final class JAPJIntField
extends JTextField {
    public static final int NO_MAXIMUM_BOUND = -1;
    public static final int ALLOW_ZEROS_NONE = 0;
    public static final int ALLOW_ZEROS_ONE = 1;
    public static final int ALLOW_ZEROS_UNTIL_BOUND = 2;
    private static final String MSG_NO_VALID_INTEGER = (class$gui$JAPJIntField == null ? (class$gui$JAPJIntField = JAPJIntField.class$("gui.JAPJIntField")) : class$gui$JAPJIntField).getName() + "_noValidInteger";
    private IIntFieldBounds m_bounds;
    private boolean b_bAutoTransferFocus;
    static /* synthetic */ Class class$gui$JAPJIntField;

    public JAPJIntField() {
        this(-1, false);
    }

    public JAPJIntField(int a_maxValue) {
        this(a_maxValue, false);
    }

    public JAPJIntField(int a_maxValue, boolean a_bAutoTransferFocus) {
        this(new DefaultBounds(a_maxValue), a_bAutoTransferFocus);
    }

    public JAPJIntField(IIntFieldBounds a_bounds) {
        this(a_bounds, false);
    }

    public JAPJIntField(IIntFieldBounds a_bounds, boolean a_bAutoTransferFocus) {
        super(JAPJIntField.parseNumberOfDigits(a_bounds.getMaximum()));
        if (a_bounds.getAllowZeros() < 0 || a_bounds.getAllowZeros() > 2) {
            throw new IllegalArgumentException("getAllowZeros() returned an illegal value: " + a_bounds.getAllowZeros());
        }
        this.m_bounds = a_bounds;
        this.b_bAutoTransferFocus = a_bAutoTransferFocus;
    }

    public void setInt(int a_integer) {
        this.setText(Integer.toString(a_integer));
    }

    public int getInt() throws NumberFormatException {
        Object[] arguments = new Object[2];
        arguments[1] = this.getName() == null || this.getName().trim().length() == 0 ? ClassUtil.getShortClassName(this.getClass()) : this.getName();
        try {
            int integer = Integer.parseInt(this.getText());
            if (!(integer < 0 || this.m_bounds.getAllowZeros() == 0 && integer == 0 || this.m_bounds.getMaximum() >= 0 && integer > this.m_bounds.getMaximum())) {
                return integer;
            }
            arguments[0] = new Integer(integer);
        }
        catch (NumberFormatException a_e) {
            arguments[0] = this.getText();
        }
        throw new NumberFormatException(JAPMessages.getString(MSG_NO_VALID_INTEGER, arguments));
    }

    public void updateBounds() {
        try {
            if (this.getInt() > this.m_bounds.getMaximum()) {
                this.setInt(this.m_bounds.getMaximum());
            }
            if (this.m_bounds.getAllowZeros() == 0 && this.getInt() == 0) {
                this.setInt(1);
            }
        }
        catch (NumberFormatException a_e) {
            if (this.m_bounds.getAllowZeros() > 0) {
                this.setInt(0);
            }
            this.setInt(1);
        }
    }

    protected final Document createDefaultModel() {
        return new IntDocument();
    }

    private static int parseNumberOfDigits(int a_integer) {
        int digits = 0;
        while (a_integer > 0) {
            ++digits;
            a_integer /= 10;
        }
        if (digits == 0) {
            digits = 1;
        }
        return digits;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class IntDocument
    extends PlainDocument {
        private IntDocument() {
        }

        public void insertString(int offSet, String string, AttributeSet attributeSet) throws BadLocationException {
            int currentInt;
            if (string == null || string.trim().length() == 0) {
                return;
            }
            try {
                currentInt = Integer.parseInt(this.getText(0, this.getLength()) + string);
            }
            catch (NumberFormatException e) {
                return;
            }
            if (JAPJIntField.this.m_bounds.getAllowZeros() < 2 ? currentInt < 10 && offSet > 0 : JAPJIntField.this.m_bounds.getMaximum() >= 0 && JAPJIntField.parseNumberOfDigits(JAPJIntField.this.m_bounds.getMaximum()) < offSet + 1) {
                return;
            }
            if ((JAPJIntField.this.m_bounds.getMaximum() < 0 || currentInt <= JAPJIntField.this.m_bounds.getMaximum()) && (JAPJIntField.this.m_bounds.getAllowZeros() > 0 || JAPJIntField.this.m_bounds.getAllowZeros() == 0 && currentInt > 0)) {
                super.insertString(offSet, string, attributeSet);
            }
            if (JAPJIntField.this.m_bounds.getMaximum() >= 0 && JAPJIntField.this.b_bAutoTransferFocus && this.getLength() > 0 && offSet + 1 == JAPJIntField.parseNumberOfDigits(JAPJIntField.this.m_bounds.getMaximum())) {
                JAPJIntField.this.transferFocus();
            }
        }
    }

    private static final class DefaultBounds
    extends AbstractIntFieldBounds {
        public DefaultBounds(int a_maximum) {
            super(a_maximum);
        }

        public int getAllowZeros() {
            return 1;
        }
    }

    public static final class IntFieldWithoutZeroBounds
    extends AbstractIntFieldBounds {
        public IntFieldWithoutZeroBounds(int a_maxValue) {
            super(a_maxValue);
        }

        public int getAllowZeros() {
            return 0;
        }
    }

    public static final class IntFieldUnlimitedZerosBounds
    extends AbstractIntFieldBounds {
        public IntFieldUnlimitedZerosBounds(int a_maxValue) {
            super(a_maxValue);
        }

        public int getAllowZeros() {
            return 2;
        }
    }

    public static abstract class AbstractIntFieldBounds
    implements IIntFieldBounds {
        private int m_maxValue;

        public AbstractIntFieldBounds(int a_maxValue) {
            this.m_maxValue = a_maxValue;
        }

        public final int getMaximum() {
            return this.m_maxValue;
        }

        public abstract /* synthetic */ int getAllowZeros();
    }

    public static interface IIntFieldBounds {
        public int getAllowZeros();

        public int getMaximum();
    }
}

