/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import logging.LogHolder;
import logging.LogType;

public class MixConfigTextField
extends JTextField {
    public MixConfigTextField() {
    }

    public MixConfigTextField(int columns) {
        super(columns);
    }

    public MixConfigTextField(String text, int columns) {
        super(text, columns);
    }

    @Override
    protected final Document createDefaultModel() {
        return new MixConfigDocument();
    }

    private final class MixConfigDocument
    extends PlainDocument {
        String sBlacklistedChars = "<>&";
        String sRegexAllowedChar = "[^" + this.sBlacklistedChars + "]";
        Pattern p = Pattern.compile("[" + this.sBlacklistedChars + "]");

        private MixConfigDocument() {
        }

        @Override
        public void insertString(int offSet, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string.length() == 1 && string.matches(this.sRegexAllowedChar)) {
                super.insertString(offSet, string, attributeSet);
            } else if (string.length() > 1) {
                Matcher m = this.p.matcher(string);
                String newString = m.replaceAll("");
                super.insertString(offSet, newString, attributeSet);
            } else {
                LogHolder.log(7, LogType.GUI, "Rejecting " + string);
                return;
            }
        }
    }
}

