/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.network;

import gui.MixConfigTextField;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import mixconfig.MixConfig;
import mixconfig.network.ConnectionData;
import mixconfig.network.ConnectionDialog;
import mixconfig.network.ConnectionTableModel;

public class OutgoingDialog
extends ConnectionDialog {
    private ButtonGroup proxytype;
    private MixConfigTextField m_tfVisibleAddress;

    @Override
    protected String getType() {
        return this.proxytype == null ? "NextMix" : "Proxy";
    }

    @Override
    protected ConnectionData getData() {
        ConnectionData data = super.getData();
        if (this.proxytype != null) {
            String strAction = this.proxytype.getSelection().getActionCommand();
            int flag = 0;
            if (strAction != null) {
                if (strAction.equalsIgnoreCase("HTTP")) {
                    flag = 1;
                } else if (strAction.equalsIgnoreCase("Socks")) {
                    flag = 2;
                } else if (strAction.equalsIgnoreCase("VPN")) {
                    flag = 4;
                }
            }
            data.setFlags(flag);
            data.setVisibleAddress(this.m_tfVisibleAddress.getText());
        }
        return data;
    }

    protected void addType(ConnectionData data, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc) {
        JLabel label = new JLabel("Proxy Type");
        layout.setConstraints(label, lc);
        this.getContentPane().add(label);
        ++lc.gridy;
        int ptype = data == null ? 1 : data.getFlags() & 7;
        rc.anchor = 10;
        rc.gridwidth = 3;
        this.proxytype = new ButtonGroup();
        JRadioButton t = new JRadioButton("HTTP", ptype == 1);
        t.setActionCommand("HTTP");
        layout.setConstraints(t, rc);
        this.getContentPane().add(t);
        this.proxytype.add(t);
        if (this.getFirstone() == null) {
            this.setFirstone(t);
        }
        rc.gridx += 4;
        t = new JRadioButton("Socks", ptype == 2);
        t.setActionCommand("Socks");
        layout.setConstraints(t, rc);
        this.getContentPane().add(t);
        this.proxytype.add(t);
        rc.gridx += 4;
        t = new JRadioButton("VPN", ptype == 4);
        t.setActionCommand("VPN");
        layout.setConstraints(t, rc);
        this.getContentPane().add(t);
        this.proxytype.add(t);
        ++rc.gridy;
        rc.gridx -= 8;
    }

    protected void addVisibleAddress(ConnectionData data, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc) {
        JLabel m_labelVisibleAddress = new JLabel("Visible Address");
        layout.setConstraints(m_labelVisibleAddress, lc);
        this.getContentPane().add(m_labelVisibleAddress);
        ++lc.gridy;
        rc.anchor = 17;
        rc.gridwidth = 7;
        this.m_tfVisibleAddress = data == null ? new MixConfigTextField(14) : new MixConfigTextField(data.getVisibleAddress(), 14);
        this.m_tfVisibleAddress.setMinimumSize(this.m_tfVisibleAddress.getPreferredSize());
        layout.setConstraints(this.m_tfVisibleAddress, rc);
        this.getContentPane().add(this.m_tfVisibleAddress);
        this.m_tfVisibleAddress.addActionListener(this.nextfocusaction);
        ++rc.gridy;
    }

    private void createDialog(ConnectionData data, ConnectionTableModel where) {
        this.setSize(500, 350);
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 17;
        lc.insets = new Insets(5, 5, 5, 5);
        lc.gridx = 0;
        lc.gridy = 0;
        lc.weightx = 1.0;
        GridBagConstraints rc = new GridBagConstraints();
        rc.anchor = 17;
        rc.insets = new Insets(5, 5, 5, 5);
        rc.gridx = 1;
        rc.gridy = 0;
        rc.weightx = 0.0;
        if (MixConfig.getMixConfiguration().getMixType() == 4) {
            this.addType(data, layout, lc, rc);
        } else {
            this.proxytype = null;
        }
        this.addTransport(data, layout, lc, rc);
        this.addName(data, layout, lc, rc, true);
        this.addPort(data, layout, lc, rc);
        if (MixConfig.getMixConfiguration().getMixType() == 4) {
            this.addVisibleAddress(data, layout, lc, rc);
        }
        this.addKeys(data, where, layout, lc, rc);
        this.pack();
        this.getFirstone().requestFocus();
    }

    public OutgoingDialog(Frame parent, String title, ConnectionTableModel where) {
        super(parent, title);
        this.createDialog(null, where);
    }

    public OutgoingDialog(Frame parent, String title, ConnectionTableModel where, ConnectionData data) {
        super(parent, title);
        this.createDialog(data, where);
    }
}

