/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.util.JAPMessages;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import gui.ClipFrame;
import gui.GUIUtils;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import logging.LogHolder;
import logging.LogType;
import mixconfig.MixConfig;
import mixconfig.panels.ChooseStorageMethodPane;
import mixconfig.panels.DataRetentionPanel;
import mixconfig.panels.MixConfigPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogCrimePanel
extends MixConfigPanel
implements ActionListener,
KeyListener {
    private static final String MSG_CRIME_TITLE = LogCrimePanel.class.getName() + "_title";
    private static final String MSG_GLOBAL_PARAMS = LogCrimePanel.class.getName() + "_globalParams";
    private static final String MSG_LOG_PAYLOAD = LogCrimePanel.class.getName() + "_logPayload";
    private static final String MSG_URL_PANEL_NAME = LogCrimePanel.class.getName() + "_urlPanelName";
    private static final String MSG_PAYLOAD_PANEL_NAME = LogCrimePanel.class.getName() + "_payloadPanelName";
    private static final String MSG_IP_PANEL_NAME = LogCrimePanel.class.getName() + "_ipPanelName";
    private static final String MSG_INVALID_REGEXP = LogCrimePanel.class.getName() + "_invalidRegExp";
    private static final String MSG_INVALID_IP = LogCrimePanel.class.getName() + "_invalidIP";
    private static final String MSG_CHOOSE_LOAD_METHOD = LogCrimePanel.class.getName() + "_chooseLoadMethod";
    private static final String MSG_CHOOSE_SAVE_METHOD = LogCrimePanel.class.getName() + "_chooseSaveMethod";
    private static final String XML_ELEMENT_CRIME_DETECTION = "CrimeDetection";
    private static final String XML_ELEMENT_REG_EXP_URL = "RegExpURL";
    private static final String XML_ELEMENT_REG_EXP_PAYLOAD = "RegExpPayload";
    private static final String XML_ELEMENT_SURVEILLANCE_IP = "SurveillanceIP";
    private static final String XML_ATTR_LOG_PAYLOAD = "logPayload";
    private static final int URL_PANEL = 0;
    private static final int PAYLOAD_PANEL = 1;
    private static final int IP_PANEL = 2;
    private static final int PANELS = 3;
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final String[] XML_ELEMENT_NAMES = new String[]{"RegExpURL", "RegExpPayload", "SurveillanceIP"};
    private static final String[] PANEL_NAME_KEYS = new String[]{MSG_URL_PANEL_NAME, MSG_PAYLOAD_PANEL_NAME, MSG_IP_PANEL_NAME};
    private static final String[] PANEL_INPUT_ERROR_KEYS = new String[]{MSG_INVALID_REGEXP, MSG_INVALID_REGEXP, MSG_INVALID_IP};
    private JPanel globalPanel;
    private JCheckBox payloadLoggingCheckBox;
    private JButton m_btnImport;
    private JButton m_btnExport;
    private JButton[] addButtons;
    private JButton[] removeButtons;
    private JComboBox[] parameterBoxes;
    private JTextComponent[] inputComponents;
    private JPanel[] surveillanceParameterPanels;
    private DataRetentionPanel dataRetentionPanel;
    private InputChecker[] inputChecker;
    private static LogCrimePanel panelSingleton = null;

    public static LogCrimePanel get() {
        if (panelSingleton == null) {
            panelSingleton = new LogCrimePanel();
        }
        return panelSingleton;
    }

    protected LogCrimePanel() {
        super(JAPMessages.getString(MSG_CRIME_TITLE));
        this.initComponents();
        this.placeComponents();
        this.enableComponents();
    }

    private void initComponents() {
        this.initGlobalPanel();
        this.addButtons = new JButton[3];
        this.removeButtons = new JButton[3];
        this.parameterBoxes = new JComboBox[3];
        this.inputComponents = new JTextComponent[3];
        this.surveillanceParameterPanels = new JPanel[3];
        this.inputChecker = new InputChecker[3];
        for (int i = 0; i < 3; ++i) {
            this.addButtons[i] = GUIUtils.createButton("bttnAdd");
            this.addButtons[i].addActionListener(this);
            this.removeButtons[i] = GUIUtils.createButton("bttnRemove");
            this.removeButtons[i].addActionListener(this);
            this.inputComponents[i] = new JTextField(50);
            this.inputComponents[i].addKeyListener(this);
            this.parameterBoxes[i] = new JComboBox();
            this.parameterBoxes[i].addItemListener(this);
            this.surveillanceParameterPanels[i] = LogCrimePanel.createSurveillanceParameterPanel(PANEL_NAME_KEYS[i], this.parameterBoxes[i], this.removeButtons[i], this.inputComponents[i], this.addButtons[i]);
            this.inputChecker[i] = i == 2 ? new InputChecker(){

                @Override
                public boolean checkInput(String input) {
                    return LogCrimePanel.this.checkIP(input);
                }
            } : new InputChecker(){

                @Override
                public boolean checkInput(String input) {
                    return LogCrimePanel.this.checkRegExp(input);
                }
            };
        }
        this.dataRetentionPanel = new DataRetentionPanel(this);
    }

    void placeComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(3, 3, 3, 3);
        c.anchor = 17;
        c.fill = 1;
        c.gridwidth = 0;
        this.add((Component)this.globalPanel, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        while (c.gridx < this.surveillanceParameterPanels.length) {
            this.add((Component)this.surveillanceParameterPanels[c.gridx], c);
            ++c.gridx;
        }
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.dataRetentionPanel, c);
    }

    @Override
    public Vector<String> check() {
        return new Vector<String>();
    }

    @Override
    protected void enableComponents() {
        int i;
        for (i = 0; i < this.addButtons.length; ++i) {
            this.addButtons[i].setEnabled(this.inputChecker[i].checkInput(this.inputComponents[i].getText()));
        }
        for (i = 0; i < this.removeButtons.length; ++i) {
            this.removeButtons[i].setEnabled(this.parameterBoxes[i].getSelectedItem() != null);
        }
    }

    @Override
    public String getHelpContext() {
        return "index";
    }

    @Override
    public Component getHelpExtractionDisplayContext() {
        return null;
    }

    private void initGlobalPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(3, 3, 3, 3);
        c.anchor = 17;
        c.fill = 0;
        this.globalPanel = new JPanel();
        this.globalPanel.setLayout(new GridBagLayout());
        this.globalPanel.setBorder(new TitledBorder(JAPMessages.getString(MSG_GLOBAL_PARAMS)));
        this.m_btnImport = new JButton("Import");
        this.m_btnImport.addActionListener(this);
        this.globalPanel.add((Component)this.m_btnImport, c);
        this.m_btnExport = new JButton("Export");
        this.m_btnExport.addActionListener(this);
        ++c.gridx;
        this.globalPanel.add((Component)this.m_btnExport, c);
        this.payloadLoggingCheckBox = new JCheckBox();
        this.payloadLoggingCheckBox.addActionListener(this);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        this.globalPanel.add((Component)GUIUtils.createLabel(MSG_LOG_PAYLOAD), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.globalPanel.add((Component)this.payloadLoggingCheckBox, c);
    }

    private static JPanel createSurveillanceParameterPanel(String nameKey, JComboBox parameters, JButton removeButton, JTextComponent inputComponent, JButton addButton) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(3, 3, 3, 3);
        c.anchor = 17;
        c.fill = 2;
        JPanel surveillanceParameterPanel = new JPanel();
        surveillanceParameterPanel.setBorder(new TitledBorder(JAPMessages.getString(nameKey)));
        surveillanceParameterPanel.setLayout(new GridBagLayout());
        surveillanceParameterPanel.add((Component)parameters, c);
        c.weighty = 0.0;
        c.fill = 1;
        ++c.gridy;
        surveillanceParameterPanel.add((Component)inputComponent, c);
        ++c.gridy;
        c.weighty = 0.1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        surveillanceParameterPanel.add((Component)addButton, c);
        ++c.gridx;
        surveillanceParameterPanel.add((Component)removeButton, c);
        return surveillanceParameterPanel;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.enableComponents();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton[] currentArray = null;
        if (e.getSource() == this.payloadLoggingCheckBox) {
            this.saveAfterAction();
            return;
        }
        if (e.getSource() == this.m_btnImport) {
            byte[] data;
            JAPDialog dialog = new JAPDialog(this, "Import crime detection settings");
            ChooseStorageMethodPane pane = new ChooseStorageMethodPane(dialog, JAPMessages.getString(MSG_CHOOSE_LOAD_METHOD));
            pane.updateDialog();
            dialog.pack();
            dialog.setResizable(false);
            dialog.setVisible(true);
            if (pane.getButtonValue() != 0) {
                return;
            }
            if (pane.isMethodFile()) {
                data = MixConfig.openFile(this, 2);
                if (data == null) {
                    return;
                }
            } else {
                data = GUIUtils.getTextFromClipboard(this).getBytes();
            }
            try {
                Element node = XMLUtil.toXMLDocument(data).getDocumentElement();
                XMLUtil.assertNodeName(node, XML_ELEMENT_CRIME_DETECTION);
                this.save(node);
                this.load();
            }
            catch (Exception a_e) {
                JAPDialog.showErrorDialog((Component)this, "Cannot read imported settings. They might be damaged.", (Throwable)a_e);
            }
        } else if (e.getSource() == this.m_btnExport) {
            this.exportCert();
        } else {
            for (int actionType = 0; actionType <= 1; ++actionType) {
                currentArray = actionType == 0 ? this.addButtons : this.removeButtons;
                for (int i = 0; i < currentArray.length; ++i) {
                    if (e.getSource() != currentArray[i]) continue;
                    if (actionType == 0) {
                        this.addInput(i);
                    } else {
                        this.removeSelectedParameter(i);
                    }
                    this.enableComponents();
                    this.saveAfterAction();
                    return;
                }
            }
        }
    }

    private void exportCert() {
        File file = null;
        Element crimeDetectionRoot = (Element)XMLUtil.getFirstChildByName(this.getConfiguration().getDocument().getDocumentElement(), XML_ELEMENT_CRIME_DETECTION);
        if (crimeDetectionRoot == null) {
            return;
        }
        JAPDialog dialog = new JAPDialog(this, "Export crime detection settings");
        ChooseStorageMethodPane pane = new ChooseStorageMethodPane(dialog, JAPMessages.getString(MSG_CHOOSE_SAVE_METHOD));
        pane.updateDialog();
        dialog.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        if (pane.getButtonValue() != 0) {
            return;
        }
        Document doc = XMLUtil.createDocument();
        try {
            doc.appendChild(XMLUtil.importNode(doc, crimeDetectionRoot, true));
        }
        catch (XMLParseException a_e) {
            JAPDialog.showErrorDialog((Component)this, (Throwable)a_e);
            return;
        }
        if (pane.isMethodFile()) {
            do {
                String fname;
                JFileChooser fd;
                if ((fd = MixConfig.showFileDialog(this, 1, 2)) == null) {
                    return;
                }
                file = fd.getSelectedFile();
                if (file == null || (fname = file.getName()).indexOf(46) >= 0) continue;
                file = new File(file.getParent(), fname + ".xml");
            } while (file != null && file.exists() && JAPDialog.showConfirmDialog((Component)this, JAPMessages.getString(ChooseStorageMethodPane.MSG_CONFIRM_OVERWRITE), 2, 3) != 0);
            try {
                if (file != null) {
                    XMLUtil.write(doc, file);
                }
            }
            catch (IOException a_e) {
                ClipFrame save = new ClipFrame(this, "I/O error while saving, try clipboard. Copy and Save this file in a new Location.", false);
                save.setText(XMLUtil.toString(doc));
                save.setVisible(true);
            }
        } else {
            GUIUtils.saveTextToClipboard(XMLUtil.toString(doc), this);
        }
    }

    private void addInput(int panelIndex) {
        String input = this.inputComponents[panelIndex].getText();
        if (this.inputChecker[panelIndex].checkInput(input)) {
            this.updateParameterBox(input.trim(), panelIndex);
        } else {
            JAPDialog.showErrorDialog((Component)this, JAPMessages.getString(PANEL_INPUT_ERROR_KEYS[panelIndex], input));
        }
    }

    private void removeSelectedParameter(int panelIndex) {
        Object item = this.parameterBoxes[panelIndex].getSelectedItem();
        if (item != null) {
            this.parameterBoxes[panelIndex].removeItemAt(this.parameterBoxes[panelIndex].getSelectedIndex());
        }
    }

    private void updateParameterBox(String newItem, int boxIndex) {
        Object item = null;
        for (int i = 0; i < this.parameterBoxes[boxIndex].getItemCount(); ++i) {
            item = this.parameterBoxes[boxIndex].getItemAt(i);
            if (item == null || !(item instanceof String) || !item.equals(newItem)) continue;
            this.parameterBoxes[boxIndex].setSelectedIndex(i);
            return;
        }
        this.parameterBoxes[boxIndex].addItem(newItem);
        this.parameterBoxes[boxIndex].setSelectedItem(newItem);
    }

    private boolean checkRegExp(String regExp) {
        if (regExp == null || regExp.equals("")) {
            return false;
        }
        try {
            Pattern.compile(regExp.trim());
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    private boolean checkIP(String ip) {
        if (ip == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(ip.trim(), ".");
        if (tokenizer.countTokens() != 4) {
            return false;
        }
        while (tokenizer.hasMoreTokens()) {
            try {
                int i = Integer.parseInt(tokenizer.nextToken());
                if (i <= 255 && i >= 0) continue;
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void load() throws IOException {
        Element crimeDetectionRoot;
        super.load(this.dataRetentionPanel);
        if (this.getConfiguration() != null && this.getConfiguration().getDocument() != null && this.getConfiguration().getDocument().getDocumentElement() != null && (crimeDetectionRoot = (Element)XMLUtil.getFirstChildByName(this.getConfiguration().getDocument().getDocumentElement(), XML_ELEMENT_CRIME_DETECTION)) != null) {
            this.payloadLoggingCheckBox.setSelected(XMLUtil.parseAttribute((Node)crimeDetectionRoot, XML_ATTR_LOG_PAYLOAD, false));
            NodeList crimeDetectionElements = null;
            String textContent = null;
            for (int panelIndex = 0; panelIndex < 3; ++panelIndex) {
                crimeDetectionElements = crimeDetectionRoot.getElementsByTagName(XML_ELEMENT_NAMES[panelIndex]);
                for (int i = 0; i < crimeDetectionElements.getLength(); ++i) {
                    textContent = crimeDetectionElements.item(i).getTextContent();
                    if (textContent == null || textContent.equals("")) continue;
                    if (this.inputChecker[panelIndex].checkInput(textContent = textContent.trim())) {
                        this.updateParameterBox(textContent, panelIndex);
                        continue;
                    }
                    LogHolder.log(4, LogType.MISC, "The parameter " + textContent + " is invalid and therefore not loaded.");
                }
            }
        }
    }

    private void saveAfterAction() {
        try {
            this.save();
        }
        catch (IOException e) {
            LogHolder.log(4, LogType.MISC, "Saving crime detection options impossible due to an IOException.", e);
        }
    }

    @Override
    public void save() throws IOException {
        this.save((Element)null);
    }

    private void save(Element a_configElement) throws IOException {
        Element oldCrimeDetectionRoot;
        Document configDoc = this.getConfiguration() != null ? this.getConfiguration().getDocument() : null;
        NodeList nl = null;
        Element crimeDetectionRoot = a_configElement;
        if (crimeDetectionRoot != null && configDoc != null) {
            try {
                crimeDetectionRoot = (Element)XMLUtil.importNode(configDoc, crimeDetectionRoot, true);
            }
            catch (XMLParseException a_e) {
                LogHolder.log(2, LogType.MISC, a_e);
                throw new IOException("Error while importing node!");
            }
        }
        if (configDoc != null && configDoc.getDocumentElement() != null) {
            nl = configDoc.getElementsByTagName(XML_ELEMENT_CRIME_DETECTION);
            if (crimeDetectionRoot == null) {
                crimeDetectionRoot = configDoc.createElement(XML_ELEMENT_CRIME_DETECTION);
                Object selectedItem = null;
                for (int panelIndex = 0; panelIndex < 3; ++panelIndex) {
                    for (int i = 0; i < this.parameterBoxes[panelIndex].getItemCount(); ++i) {
                        selectedItem = this.parameterBoxes[panelIndex].getItemAt(i);
                        if (selectedItem == null || !(selectedItem instanceof String)) continue;
                        Element parameterElement = configDoc.createElement(XML_ELEMENT_NAMES[panelIndex]);
                        parameterElement.setTextContent(((String)selectedItem).trim());
                        crimeDetectionRoot.appendChild(parameterElement);
                    }
                }
                crimeDetectionRoot.setAttribute(XML_ATTR_LOG_PAYLOAD, Boolean.toString(this.payloadLoggingCheckBox.isSelected()));
            }
        }
        Element element = oldCrimeDetectionRoot = nl != null && nl.getLength() > 0 ? (Element)nl.item(0) : null;
        if (crimeDetectionRoot != null && crimeDetectionRoot.hasChildNodes()) {
            if (oldCrimeDetectionRoot != null) {
                oldCrimeDetectionRoot.getParentNode().replaceChild(crimeDetectionRoot, oldCrimeDetectionRoot);
            } else if (configDoc != null) {
                configDoc.getDocumentElement().appendChild(crimeDetectionRoot);
            }
        } else if (oldCrimeDetectionRoot != null) {
            oldCrimeDetectionRoot.getParentNode().removeChild(oldCrimeDetectionRoot);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            this.enableComponents();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private static interface InputChecker {
        public boolean checkInput(String var1);
    }
}

