/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools;

import anon.crypto.JAPCertificate;
import anon.crypto.PKCS12;
import anon.util.JAPMessages;
import gui.JAPHelpContext;
import gui.dialog.JAPDialog;
import gui.dialog.ValidityContentPane;
import gui.help.JAPHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mixconfig.panels.CertPanel;

public class CertificationTool
extends JAPDialog
implements ActionListener,
ChangeListener,
JAPHelpContext.IHelpContext {
    private static final String MSG_CONFIRMATION_TITLE = CertificationTool.class.getName() + "_confirmationTitle";
    private static final String MSG_CONFIRMATION = CertificationTool.class.getName() + "_confirmationMessage";
    private CertPanel m_publicCertPanel;
    private CertPanel m_privateCertPanel;
    private JButton m_btnSign;

    public CertificationTool(Frame parent) {
        super(parent, "Sign a public certificate", true);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gbl);
        constraints.anchor = 11;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.m_publicCertPanel = new CertPanel("Public certificate", "Hint: Public Certificate to be signed ", (JAPCertificate)null, 3, 0);
        this.m_publicCertPanel.setName("Public Certificate");
        this.m_publicCertPanel.addChangeListener(this);
        this.getContentPane().add((Component)this.m_publicCertPanel, constraints);
        constraints.anchor = 10;
        ++constraints.gridy;
        this.m_privateCertPanel = new CertPanel("Private certificate", "Hint: Private Certificate to sign a Public Certificate", (PKCS12)null, 3, 0);
        this.m_privateCertPanel.setName("Private Certificate");
        this.m_privateCertPanel.addChangeListener(this);
        this.getContentPane().add((Component)this.m_privateCertPanel, constraints);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        constraints.fill = 2;
        JPanel panelButtons = new JPanel(new GridBagLayout());
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        buttonConstraints.anchor = 17;
        buttonConstraints.gridx = 0;
        buttonConstraints.gridy = 0;
        buttonConstraints.insets = constraints.insets;
        this.m_btnSign = new JButton("Sign Certificate");
        this.m_btnSign.addActionListener(this);
        panelButtons.add((Component)this.m_btnSign, buttonConstraints);
        this.m_btnSign.setEnabled(false);
        ++buttonConstraints.gridx;
        panelButtons.add((Component)JAPHelp.createHelpButton(this), buttonConstraints);
        this.getContentPane().add((Component)panelButtons, constraints);
        this.pack();
        this.setResizable(false);
        this.setVisible(true, false);
    }

    @Override
    public String getHelpContext() {
        return "index";
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_publicCertPanel.getCert() != null && this.m_privateCertPanel.getCert() != null) {
            JAPDialog dialog = new JAPDialog(this, "Set a new certificate validity.", true);
            ValidityContentPane contentPane = new ValidityContentPane(dialog);
            contentPane.updateDialog();
            dialog.pack();
            dialog.setResizable(false);
            dialog.setVisible(true);
            if (contentPane.getValidity() != null) {
                JAPCertificate signedCertificate = ((JAPCertificate)this.m_publicCertPanel.getCert()).sign((PKCS12)this.m_privateCertPanel.getCert(), contentPane.getValidity(), ((JAPCertificate)this.m_publicCertPanel.getCert()).getExtensions(), new BigInteger("0"));
                this.m_publicCertPanel.setCert(signedCertificate);
                JAPDialog.showMessageDialog((JAPDialog)this, JAPMessages.getString(MSG_CONFIRMATION), JAPMessages.getString(MSG_CONFIRMATION_TITLE));
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.m_btnSign.setEnabled(this.m_publicCertPanel.getCert() != null && this.m_privateCertPanel.getCert() != null);
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

