/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.wizard;

import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mixconfig.ChoicePanel;
import mixconfig.Menu;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.wizard.CannotContinueException;
import mixconfig.wizard.ConfigWizardPanel;
import mixconfig.wizard.WizardLayout;

public class ConfigWizard
extends WizardLayout
implements ActionListener,
ChangeListener {
    private ConfigWizardPanel m_wizPanel = new ConfigWizardPanel();

    public ConfigWizard() throws IOException {
        this.m_wizPanel.addChangeListener(this);
        this.add((Component)this.m_wizPanel, "Center");
        this.getButtonForward().addActionListener(this);
        this.getButtonBack().addActionListener(this);
        this.getButtonCancel().addActionListener(this);
        this.stateChanged(null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getButtonForward().setText("Next ->");
            try {
                Menu menu;
                if (e.getSource() == this.getButtonForward()) {
                    this.m_wizPanel.checkAndForward();
                } else if (e.getSource() == this.getButtonBack()) {
                    if ((this.m_wizPanel.getState() & 1) == 0) {
                        this.m_wizPanel.back();
                    } else {
                        menu = ((ChoicePanel)this.getParent()).getMenu();
                        menu.actionPerformed(new ActionEvent(this, 1001, "New_from_Cancel"));
                    }
                } else if (e.getSource() == this.getButtonCancel()) {
                    menu = ((ChoicePanel)this.getParent()).getMenu();
                    menu.actionPerformed(new ActionEvent(this, 1001, "New_from_Cancel"));
                }
                int i = this.m_wizPanel.getState();
                if ((i & 2) != 0) {
                    this.getButtonForward().setText("Finish");
                }
            }
            catch (CannotContinueException cce) {
                int i = this.m_wizPanel.getState();
                if ((i & 4) > 0) {
                    String[] msg = cce.getMessages();
                    if (msg != null && msg.length > 0 && JAPDialog.showYesNoDialog((Component)this, msg[0] + " Continue anyway?", "Errors")) {
                        this.m_wizPanel.doForward();
                    }
                } else if ((i & 2) > 0) {
                    this.getButtonForward().setText("Finish");
                    File file = MixConfig.getMixConfiguration().saveToFile();
                    if (file != null) {
                        JAPDialog.showMessageDialog((Component)MixConfig.getMainWindow(), "Configuration saved as " + file, "Configuration saved");
                        this.m_wizPanel.finish();
                        ((ChoicePanel)this.getParent()).getMenu().reset(false);
                        this.stateChanged(new ChangeEvent(this));
                    }
                }
            }
        }
        catch (Exception ex) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)ex);
        }
        ((ChoicePanel)this.getParent()).setMessageTitle();
    }

    public void load() {
        try {
            this.m_wizPanel.load();
        }
        catch (Exception io) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), "Switching View to Wizard: Error on loading the MixConfiguration", (Throwable)io);
        }
    }

    public void setConfiguration(MixConfiguration mixconfig) {
        try {
            this.m_wizPanel.setConfiguration(mixconfig);
        }
        catch (Exception io) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), "Switching View to Wizard: Error on loading the MixConfiguration", (Throwable)io);
        }
    }

    public void reset() {
        this.m_wizPanel.reset();
    }

    public void changeButtonLabelToNext() {
        this.getButtonForward().setText("Next ->");
    }

    @Override
    public String getHelpContext() {
        return this.m_wizPanel.getHelpContext();
    }

    public int getPageCount() {
        return this.m_wizPanel.getPageCount();
    }

    public int getCurrentPageNr() {
        return this.m_wizPanel.getCurrentPageNr();
    }

    public Class getCurrentPageClass() {
        return this.m_wizPanel.getCurrentPage().getClass();
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }
}

