/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.ByteSignature;
import anon.crypto.JAPCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;

public class PKCS7SignedData
implements PKCSObjectIdentifiers {
    private int version;
    private int signerversion;
    private Hashtable digestalgos;
    private Vector certs;
    private JAPCertificate signCert;
    private byte[] digest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private final String ID_MD5 = "1.2.840.113549.2.5";
    private final String ID_MD2 = "1.2.840.113549.2.2";
    private final String ID_SHA1 = "1.3.14.3.2.26";
    private final String ID_RSA = "1.2.840.113549.1.1.1";
    private final String ID_DSA = "1.2.840.10040.4.1";

    public PKCS7SignedData(byte[] byArray) throws SecurityException, InvalidKeyException, NoSuchAlgorithmException {
        DERObjectIdentifier dERObjectIdentifier;
        JAPCertificate jAPCertificate;
        Enumeration enumeration;
        DERObject dERObject;
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        try {
            dERObject = aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(dERObject instanceof ASN1Sequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo contentInfo = ContentInfo.getInstance((Object)dERObject);
        if (!contentInfo.getContentType().equals((Object)PKCSObjectIdentifiers.signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + contentInfo.getContentType().getId());
        }
        SignedData signedData = SignedData.getInstance((Object)contentInfo.getContent());
        this.certs = new Vector();
        if (signedData.getCertificates() != null) {
            enumeration = ASN1Set.getInstance((Object)signedData.getCertificates()).getObjects();
            while (enumeration.hasMoreElements()) {
                jAPCertificate = null;
                try {
                    jAPCertificate = JAPCertificate.getInstance(X509CertificateStructure.getInstance(enumeration.nextElement()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jAPCertificate == null) continue;
                this.certs.addElement(jAPCertificate);
            }
        }
        this.version = signedData.getVersion().getValue().intValue();
        this.digestalgos = new Hashtable();
        enumeration = signedData.getDigestAlgorithms().getObjects();
        while (enumeration.hasMoreElements()) {
            jAPCertificate = (ASN1Sequence)enumeration.nextElement();
            dERObjectIdentifier = (DERObjectIdentifier)jAPCertificate.getObjectAt(0);
            this.digestalgos.put(dERObjectIdentifier.getId(), dERObjectIdentifier.getId());
        }
        jAPCertificate = signedData.getSignerInfos();
        if (jAPCertificate.size() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        dERObjectIdentifier = SignerInfo.getInstance((Object)jAPCertificate.getObjectAt(0));
        this.signerversion = dERObjectIdentifier.getVersion().getValue().intValue();
        IssuerAndSerialNumber issuerAndSerialNumber = dERObjectIdentifier.getIssuerAndSerialNumber();
        BigInteger bigInteger = issuerAndSerialNumber.getCertificateSerialNumber().getValue();
        X509Name x509Name = issuerAndSerialNumber.getName();
        Object object = this.certs.elements();
        while (object.hasMoreElements()) {
            JAPCertificate jAPCertificate2 = (JAPCertificate)object.nextElement();
            boolean bl = bigInteger.equals(jAPCertificate2.getSerialNumber());
            if (!bl || !x509Name.equals((Object)jAPCertificate2.getIssuer().getX509Name())) continue;
            this.signCert = jAPCertificate2;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + bigInteger.toString(16));
        }
        this.digestAlgorithm = dERObjectIdentifier.getDigestAlgorithm().getObjectId().getId();
        this.digest = dERObjectIdentifier.getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = dERObjectIdentifier.getDigestEncryptionAlgorithm().getObjectId().getId();
        object = this.getDigestAlgorithm();
        if (!((String)object).equalsIgnoreCase("sha1withdsa")) {
            throw new NoSuchAlgorithmException("Signature Algorithm unknown!");
        }
    }

    public String getDigestAlgorithm() {
        String string = this.digestAlgorithm;
        String string2 = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals("1.2.840.113549.2.5")) {
            string = "MD5";
        } else if (this.digestAlgorithm.equals("1.2.840.113549.2.2")) {
            string = "MD2";
        } else if (this.digestAlgorithm.equals("1.3.14.3.2.26")) {
            string = "SHA1";
        }
        if (this.digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            string2 = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            string2 = "DSA";
        }
        return string + "with" + string2;
    }

    public JAPCertificate[] getCertificates() {
        Object[] objectArray = new JAPCertificate[this.certs.size()];
        this.certs.copyInto(objectArray);
        return objectArray;
    }

    public JAPCertificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        return ByteSignature.verify(byArray, this.digest, this.signCert.getPublicKey());
    }

    private DERObject getIssuer(byte[] byArray) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            return (DERObject)aSN1Sequence.getObjectAt(aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException iOException) {
            throw new Error("IOException reading from ByteArray: " + iOException);
        }
    }
}

