/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.TableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

class TableView
extends javax.swing.text.TableView {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;

    public TableView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    void adjustSizeForCSS(int n, SizeRequirements sizeRequirements) {
        if (n == 0) {
            Object object = this.attr.getAttribute(CSS.Attribute.WIDTH);
            if (object != null) {
                int n2;
                sizeRequirements.minimum = sizeRequirements.preferred = (n2 = (int)((CSS.LengthValue)object).getValue());
                sizeRequirements.maximum = Math.max(sizeRequirements.maximum, n2);
            }
        } else {
            Object object = this.attr.getAttribute(CSS.Attribute.HEIGHT);
            if (object != null) {
                int n3;
                sizeRequirements.minimum = sizeRequirements.preferred = (n3 = (int)((CSS.LengthValue)object).getValue());
                sizeRequirements.maximum = Math.max(sizeRequirements.maximum, n3);
            }
        }
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
        this.adjustSizeForCSS(n, sizeRequirements2);
        return sizeRequirements2;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, this.createViewFactory(viewFactory));
    }

    protected TableView.TableRow createTableRow(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.TR) {
            return new RowView(element);
        }
        return null;
    }

    ViewFactory createViewFactory(ViewFactory viewFactory) {
        return new TableFactory(viewFactory);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public ViewFactory getViewFactory() {
        return this.createViewFactory(super.getViewFactory());
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, this.createViewFactory(viewFactory));
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        super.paint(graphics, rectangle);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, this.createViewFactory(viewFactory));
    }

    public void setParent(View view) {
        super.setParent(view);
        StyleSheet styleSheet = this.getStyleSheet();
        this.painter = styleSheet.getBoxPainter(this.attr);
        this.setPropertiesFromAttributes();
    }

    protected void setPropertiesFromAttributes() {
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
    }

    class RowView
    extends TableView.TableRow {
        private AttributeSet attr;

        public RowView(Element element) {
            super(TableView.this, element);
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.changedUpdate(documentEvent, shape, TableView.this.createViewFactory(viewFactory));
            int n = documentEvent.getOffset();
            if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
                this.attr = this.getStyleSheet().getViewAttributes(this);
            }
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        protected StyleSheet getStyleSheet() {
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            return hTMLDocument.getStyleSheet();
        }
    }

    static class CellView
    extends BlockView {
        public CellView(Element element) {
            super(element, 1);
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, sizeRequirements);
            sizeRequirements2.maximum = Integer.MAX_VALUE;
            return sizeRequirements2;
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMajorAxis(n, n2, nArray, nArray2);
            int n3 = 0;
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                n3 += nArray2[n5];
                ++n5;
            }
            int n6 = 0;
            if (n3 < n) {
                String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.VALIGN);
                if (string == null) {
                    AttributeSet attributeSet = this.getElement().getParentElement().getAttributes();
                    string = (String)attributeSet.getAttribute(HTML.Attribute.VALIGN);
                }
                if (string == null || string.equals("middle")) {
                    n6 = (n - n3) / 2;
                } else if (string.equals("bottom")) {
                    n6 = n - n3;
                }
            }
            if (n6 != 0) {
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = n7++;
                    nArray[n8] = nArray[n8] + n6;
                }
            }
        }
    }

    class TableFactory
    implements ViewFactory {
        ViewFactory f;

        TableFactory(ViewFactory viewFactory) {
            this.f = viewFactory;
        }

        public View create(Element element) {
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag == HTML.Tag.TR) {
                    return TableView.this.createTableRow(element);
                }
                if (tag == HTML.Tag.CAPTION) {
                    return new ParagraphView(element);
                }
            }
            return this.f.create(element);
        }
    }
}

